/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentInfo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDeploymentsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetDeploymentsResponse> {
    private static final SdkField<List<DeploymentInfo>> DEPLOYMENTS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentsInfo").getter(BatchGetDeploymentsResponse.getter(BatchGetDeploymentsResponse::deploymentsInfo)).setter(BatchGetDeploymentsResponse.setter(Builder::deploymentsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeploymentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_INFO_FIELD));
    private final List<DeploymentInfo> deploymentsInfo;

    private BatchGetDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentsInfo = builder.deploymentsInfo;
    }

    public boolean hasDeploymentsInfo() {
        return this.deploymentsInfo != null && !(this.deploymentsInfo instanceof SdkAutoConstructList);
    }

    public List<DeploymentInfo> deploymentsInfo() {
        return this.deploymentsInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentsInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsResponse)) {
            return false;
        }
        BatchGetDeploymentsResponse other = (BatchGetDeploymentsResponse)((Object)obj);
        return Objects.equals(this.deploymentsInfo(), other.deploymentsInfo());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetDeploymentsResponse").add("DeploymentsInfo", this.deploymentsInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentsInfo": {
                return Optional.ofNullable(clazz.cast(this.deploymentsInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDeploymentsResponse, T> g) {
        return obj -> g.apply((BatchGetDeploymentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<DeploymentInfo> deploymentsInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsResponse model) {
            super(model);
            this.deploymentsInfo(model.deploymentsInfo);
        }

        public final Collection<DeploymentInfo.Builder> getDeploymentsInfo() {
            return this.deploymentsInfo != null ? (Collection)this.deploymentsInfo.stream().map(DeploymentInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentsInfo(Collection<DeploymentInfo> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copy(deploymentsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentsInfo(DeploymentInfo ... deploymentsInfo) {
            this.deploymentsInfo(Arrays.asList(deploymentsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentsInfo(Consumer<DeploymentInfo.Builder> ... deploymentsInfo) {
            this.deploymentsInfo(Stream.of(deploymentsInfo).map(c -> (DeploymentInfo)((DeploymentInfo.Builder)DeploymentInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentsInfo(Collection<DeploymentInfo.BuilderImpl> deploymentsInfo) {
            this.deploymentsInfo = DeploymentsInfoListCopier.copyFromBuilder(deploymentsInfo);
        }

        @Override
        public BatchGetDeploymentsResponse build() {
            return new BatchGetDeploymentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDeploymentsResponse> {
        public Builder deploymentsInfo(Collection<DeploymentInfo> var1);

        public Builder deploymentsInfo(DeploymentInfo ... var1);

        public Builder deploymentsInfo(Consumer<DeploymentInfo.Builder> ... var1);
    }
}

