/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterOnPremisesInstanceRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterOnPremisesInstanceRequest.getter(RegisterOnPremisesInstanceRequest::instanceName)).setter(RegisterOnPremisesInstanceRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> IAM_SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterOnPremisesInstanceRequest.getter(RegisterOnPremisesInstanceRequest::iamSessionArn)).setter(RegisterOnPremisesInstanceRequest.setter(Builder::iamSessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamSessionArn").build()}).build();
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterOnPremisesInstanceRequest.getter(RegisterOnPremisesInstanceRequest::iamUserArn)).setter(RegisterOnPremisesInstanceRequest.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUserArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, IAM_SESSION_ARN_FIELD, IAM_USER_ARN_FIELD));
    private final String instanceName;
    private final String iamSessionArn;
    private final String iamUserArn;

    private RegisterOnPremisesInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String iamSessionArn() {
        return this.iamSessionArn;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterOnPremisesInstanceRequest)) {
            return false;
        }
        RegisterOnPremisesInstanceRequest other = (RegisterOnPremisesInstanceRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.iamSessionArn(), other.iamSessionArn()) && Objects.equals(this.iamUserArn(), other.iamUserArn());
    }

    public String toString() {
        return ToString.builder((String)"RegisterOnPremisesInstanceRequest").add("InstanceName", (Object)this.instanceName()).add("IamSessionArn", (Object)this.iamSessionArn()).add("IamUserArn", (Object)this.iamUserArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "iamSessionArn": {
                return Optional.ofNullable(clazz.cast(this.iamSessionArn()));
            }
            case "iamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterOnPremisesInstanceRequest, T> g) {
        return obj -> g.apply((RegisterOnPremisesInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private String iamSessionArn;
        private String iamUserArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterOnPremisesInstanceRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.iamSessionArn(model.iamSessionArn);
            this.iamUserArn(model.iamUserArn);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return this.iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterOnPremisesInstanceRequest build() {
            return new RegisterOnPremisesInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterOnPremisesInstanceRequest> {
        public Builder instanceName(String var1);

        public Builder iamSessionArn(String var1);

        public Builder iamUserArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

