/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LifecycleEventMarshaller {
    private static final MarshallingInfo<String> LIFECYCLEEVENTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleEventName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DIAGNOSTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diagnostics").isBinary(false).build();
    private static final MarshallingInfo<Instant> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endTime").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final LifecycleEventMarshaller INSTANCE = new LifecycleEventMarshaller();

    private LifecycleEventMarshaller() {
    }

    public static LifecycleEventMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LifecycleEvent lifecycleEvent, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lifecycleEvent, (String)"lifecycleEvent");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lifecycleEvent.lifecycleEventName(), LIFECYCLEEVENTNAME_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.diagnostics(), DIAGNOSTICS_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.startTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.endTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)lifecycleEvent.statusString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

