/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.Diagnostics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DiagnosticsMarshaller {
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorCode").isBinary(false).build();
    private static final MarshallingInfo<String> SCRIPTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scriptName").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").isBinary(false).build();
    private static final MarshallingInfo<String> LOGTAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logTail").isBinary(false).build();
    private static final DiagnosticsMarshaller INSTANCE = new DiagnosticsMarshaller();

    private DiagnosticsMarshaller() {
    }

    public static DiagnosticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Diagnostics diagnostics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)diagnostics, (String)"diagnostics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)diagnostics.errorCodeString(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.scriptName(), SCRIPTNAME_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.message(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)diagnostics.logTail(), LOGTAIL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

