/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.RegistrationStatus;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOnPremisesInstancesRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListOnPremisesInstancesRequest> {
    private final String registrationStatus;
    private final List<TagFilter> tagFilters;
    private final String nextToken;

    private ListOnPremisesInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.registrationStatus = builder.registrationStatus;
        this.tagFilters = builder.tagFilters;
        this.nextToken = builder.nextToken;
    }

    public RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public String registrationStatusString() {
        return this.registrationStatus;
    }

    public List<TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesRequest)) {
            return false;
        }
        ListOnPremisesInstancesRequest other = (ListOnPremisesInstancesRequest)((Object)obj);
        return Objects.equals(this.registrationStatusString(), other.registrationStatusString()) && Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListOnPremisesInstancesRequest").add("RegistrationStatus", (Object)this.registrationStatusString()).add("TagFilters", this.tagFilters()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registrationStatus": {
                return Optional.of(clazz.cast(this.registrationStatusString()));
            }
            case "tagFilters": {
                return Optional.of(clazz.cast(this.tagFilters()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String registrationStatus;
        private List<TagFilter> tagFilters;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesRequest model) {
            this.registrationStatus(model.registrationStatus);
            this.tagFilters(model.tagFilters);
            this.nextToken(model.nextToken);
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus.toString());
            return this;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        public final Collection<TagFilter.Builder> getTagFilters() {
            return this.tagFilters != null ? (Collection)this.tagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<TagFilter> tagFilters) {
            this.tagFilters = TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        public final void setTagFilters(Collection<TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListOnPremisesInstancesRequest build() {
            return new ListOnPremisesInstancesRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, ListOnPremisesInstancesRequest> {
        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder tagFilters(Collection<TagFilter> var1);

        public Builder tagFilters(TagFilter ... var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

