/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterType;
import software.amazon.awssdk.services.codedeploy.transform.EC2TagFilterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EC2TagFilter
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2TagFilter> {
    private final String key;
    private final String value;
    private final String type;

    private EC2TagFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.type = builder.type;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public EC2TagFilterType type() {
        return EC2TagFilterType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2TagFilter)) {
            return false;
        }
        EC2TagFilter other = (EC2TagFilter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.typeString(), other.typeString());
    }

    public String toString() {
        return ToString.builder((String)"EC2TagFilter").add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("Type", (Object)this.typeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2TagFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2TagFilter model) {
            this.key(model.key);
            this.value(model.value);
            this.type(model.type);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EC2TagFilterType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public EC2TagFilter build() {
            return new EC2TagFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2TagFilter> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder type(String var1);

        public Builder type(EC2TagFilterType var1);
    }
}

