/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentReadyAction;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentReadyOptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentReadyOption
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentReadyOption> {
    private final String actionOnTimeout;
    private final Integer waitTimeInMinutes;

    private DeploymentReadyOption(BuilderImpl builder) {
        this.actionOnTimeout = builder.actionOnTimeout;
        this.waitTimeInMinutes = builder.waitTimeInMinutes;
    }

    public DeploymentReadyAction actionOnTimeout() {
        return DeploymentReadyAction.fromValue(this.actionOnTimeout);
    }

    public String actionOnTimeoutString() {
        return this.actionOnTimeout;
    }

    public Integer waitTimeInMinutes() {
        return this.waitTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionOnTimeoutString());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitTimeInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentReadyOption)) {
            return false;
        }
        DeploymentReadyOption other = (DeploymentReadyOption)obj;
        return Objects.equals(this.actionOnTimeoutString(), other.actionOnTimeoutString()) && Objects.equals(this.waitTimeInMinutes(), other.waitTimeInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentReadyOption").add("ActionOnTimeout", (Object)this.actionOnTimeoutString()).add("WaitTimeInMinutes", (Object)this.waitTimeInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionOnTimeout": {
                return Optional.of(clazz.cast(this.actionOnTimeoutString()));
            }
            case "waitTimeInMinutes": {
                return Optional.of(clazz.cast(this.waitTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentReadyOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String actionOnTimeout;
        private Integer waitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentReadyOption model) {
            this.actionOnTimeout(model.actionOnTimeout);
            this.waitTimeInMinutes(model.waitTimeInMinutes);
        }

        public final String getActionOnTimeout() {
            return this.actionOnTimeout;
        }

        @Override
        public final Builder actionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
            return this;
        }

        @Override
        public final Builder actionOnTimeout(DeploymentReadyAction actionOnTimeout) {
            this.actionOnTimeout(actionOnTimeout.toString());
            return this;
        }

        public final void setActionOnTimeout(String actionOnTimeout) {
            this.actionOnTimeout = actionOnTimeout;
        }

        public final Integer getWaitTimeInMinutes() {
            return this.waitTimeInMinutes;
        }

        @Override
        public final Builder waitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
            return this;
        }

        public final void setWaitTimeInMinutes(Integer waitTimeInMinutes) {
            this.waitTimeInMinutes = waitTimeInMinutes;
        }

        public DeploymentReadyOption build() {
            return new DeploymentReadyOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentReadyOption> {
        public Builder actionOnTimeout(String var1);

        public Builder actionOnTimeout(DeploymentReadyAction var1);

        public Builder waitTimeInMinutes(Integer var1);
    }
}

