/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.InstanceAction;
import software.amazon.awssdk.services.codedeploy.transform.BlueInstanceTerminationOptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlueInstanceTerminationOption
implements StructuredPojo,
ToCopyableBuilder<Builder, BlueInstanceTerminationOption> {
    private final String action;
    private final Integer terminationWaitTimeInMinutes;

    private BlueInstanceTerminationOption(BuilderImpl builder) {
        this.action = builder.action;
        this.terminationWaitTimeInMinutes = builder.terminationWaitTimeInMinutes;
    }

    public InstanceAction action() {
        return InstanceAction.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public Integer terminationWaitTimeInMinutes() {
        return this.terminationWaitTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationWaitTimeInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueInstanceTerminationOption)) {
            return false;
        }
        BlueInstanceTerminationOption other = (BlueInstanceTerminationOption)obj;
        return Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.terminationWaitTimeInMinutes(), other.terminationWaitTimeInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"BlueInstanceTerminationOption").add("Action", (Object)this.actionString()).add("TerminationWaitTimeInMinutes", (Object)this.terminationWaitTimeInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "terminationWaitTimeInMinutes": {
                return Optional.of(clazz.cast(this.terminationWaitTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueInstanceTerminationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Integer terminationWaitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueInstanceTerminationOption model) {
            this.action(model.action);
            this.terminationWaitTimeInMinutes(model.terminationWaitTimeInMinutes);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(InstanceAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getTerminationWaitTimeInMinutes() {
            return this.terminationWaitTimeInMinutes;
        }

        @Override
        public final Builder terminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
            return this;
        }

        public final void setTerminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
        }

        public BlueInstanceTerminationOption build() {
            return new BlueInstanceTerminationOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlueInstanceTerminationOption> {
        public Builder action(String var1);

        public Builder action(InstanceAction var1);

        public Builder terminationWaitTimeInMinutes(Integer var1);
    }
}

