/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.AutoScalingGroupMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AutoScalingGroup
implements StructuredPojo,
ToCopyableBuilder<Builder, AutoScalingGroup> {
    private final String name;
    private final String hook;

    private AutoScalingGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.hook = builder.hook;
    }

    public String name() {
        return this.name;
    }

    public String hook() {
        return this.hook;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hook());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroup)) {
            return false;
        }
        AutoScalingGroup other = (AutoScalingGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.hook(), other.hook());
    }

    public String toString() {
        return ToString.builder((String)"AutoScalingGroup").add("Name", (Object)this.name()).add("Hook", (Object)this.hook()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "hook": {
                return Optional.of(clazz.cast(this.hook()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoScalingGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String hook;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroup model) {
            this.name(model.name);
            this.hook(model.hook);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getHook() {
            return this.hook;
        }

        @Override
        public final Builder hook(String hook) {
            this.hook = hook;
            return this;
        }

        public final void setHook(String hook) {
            this.hook = hook;
        }

        public AutoScalingGroup build() {
            return new AutoScalingGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AutoScalingGroup> {
        public Builder name(String var1);

        public Builder hook(String var1);
    }
}

