/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;

public final class ListDeploymentConfigsPaginator
implements SdkIterable<ListDeploymentConfigsResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentConfigsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDeploymentConfigsPaginator(CodeDeployClient client, ListDeploymentConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentConfigsResponseFetcher();
    }

    public Iterator<ListDeploymentConfigsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> deploymentConfigsList() {
        Function<ListDeploymentConfigsResponse, Iterator> getIterator = response -> response != null ? response.deploymentConfigsList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDeploymentConfigsResponseFetcher
    implements NextPageFetcher<ListDeploymentConfigsResponse> {
        private ListDeploymentConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentConfigsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDeploymentConfigsResponse nextPage(ListDeploymentConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentConfigsPaginator.this.client.listDeploymentConfigs(ListDeploymentConfigsPaginator.this.firstRequest);
            }
            return ListDeploymentConfigsPaginator.this.client.listDeploymentConfigs((ListDeploymentConfigsRequest)((Object)ListDeploymentConfigsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

