/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentGroupsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListDeploymentGroupsResponse> {
    private final String applicationName;
    private final List<String> deploymentGroups;
    private final String nextToken;

    private ListDeploymentGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroups = builder.deploymentGroups;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<String> deploymentGroups() {
        return this.deploymentGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentGroupsResponse)) {
            return false;
        }
        ListDeploymentGroupsResponse other = (ListDeploymentGroupsResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroups(), other.deploymentGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentGroupsResponse").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroups", this.deploymentGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "deploymentGroups": {
                return Optional.of(clazz.cast(this.deploymentGroups()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private String applicationName;
        private List<String> deploymentGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentGroupsResponse model) {
            this.applicationName(model.applicationName);
            this.deploymentGroups(model.deploymentGroups);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroups() {
            return this.deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String ... deploymentGroups) {
            this.deploymentGroups(Arrays.asList(deploymentGroups));
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentGroupsResponse build() {
            return new ListDeploymentGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    CopyableBuilder<Builder, ListDeploymentGroupsResponse> {
        public Builder applicationName(String var1);

        public Builder deploymentGroups(Collection<String> var1);

        public Builder deploymentGroups(String ... var1);

        public Builder nextToken(String var1);
    }
}

