/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.DeploymentCreator;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOverview;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.ErrorInformation;
import software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RollbackInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeploymentInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentInfo> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final String deploymentId;
    private final RevisionLocation previousRevision;
    private final RevisionLocation revision;
    private final String status;
    private final ErrorInformation errorInformation;
    private final Instant createTime;
    private final Instant startTime;
    private final Instant completeTime;
    private final DeploymentOverview deploymentOverview;
    private final String description;
    private final String creator;
    private final Boolean ignoreApplicationStopFailures;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final Boolean updateOutdatedInstancesOnly;
    private final RollbackInfo rollbackInfo;
    private final DeploymentStyle deploymentStyle;
    private final TargetInstances targetInstances;
    private final Boolean instanceTerminationWaitTimeStarted;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final String additionalDeploymentStatusInfo;
    private final String fileExistsBehavior;

    private DeploymentInfo(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.deploymentId = builder.deploymentId;
        this.previousRevision = builder.previousRevision;
        this.revision = builder.revision;
        this.status = builder.status;
        this.errorInformation = builder.errorInformation;
        this.createTime = builder.createTime;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.deploymentOverview = builder.deploymentOverview;
        this.description = builder.description;
        this.creator = builder.creator;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.rollbackInfo = builder.rollbackInfo;
        this.deploymentStyle = builder.deploymentStyle;
        this.targetInstances = builder.targetInstances;
        this.instanceTerminationWaitTimeStarted = builder.instanceTerminationWaitTimeStarted;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.additionalDeploymentStatusInfo = builder.additionalDeploymentStatusInfo;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public RevisionLocation previousRevision() {
        return this.previousRevision;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public DeploymentStatus status() {
        return DeploymentStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public ErrorInformation errorInformation() {
        return this.errorInformation;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant completeTime() {
        return this.completeTime;
    }

    public DeploymentOverview deploymentOverview() {
        return this.deploymentOverview;
    }

    public String description() {
        return this.description;
    }

    public DeploymentCreator creator() {
        return DeploymentCreator.fromValue(this.creator);
    }

    public String creatorString() {
        return this.creator;
    }

    public Boolean ignoreApplicationStopFailures() {
        return this.ignoreApplicationStopFailures;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public Boolean updateOutdatedInstancesOnly() {
        return this.updateOutdatedInstancesOnly;
    }

    public RollbackInfo rollbackInfo() {
        return this.rollbackInfo;
    }

    public DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public TargetInstances targetInstances() {
        return this.targetInstances;
    }

    public Boolean instanceTerminationWaitTimeStarted() {
        return this.instanceTerminationWaitTimeStarted;
    }

    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public String additionalDeploymentStatusInfo() {
        return this.additionalDeploymentStatusInfo;
    }

    public FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(this.fileExistsBehavior);
    }

    public String fileExistsBehaviorString() {
        return this.fileExistsBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentOverview());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTerminationWaitTimeStarted());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalDeploymentStatusInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileExistsBehaviorString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentInfo)) {
            return false;
        }
        DeploymentInfo other = (DeploymentInfo)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.previousRevision(), other.previousRevision()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.statusString(), other.statusString()) && Objects.equals(this.errorInformation(), other.errorInformation()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completeTime(), other.completeTime()) && Objects.equals(this.deploymentOverview(), other.deploymentOverview()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creatorString(), other.creatorString()) && Objects.equals(this.ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly()) && Objects.equals(this.rollbackInfo(), other.rollbackInfo()) && Objects.equals(this.deploymentStyle(), other.deploymentStyle()) && Objects.equals(this.targetInstances(), other.targetInstances()) && Objects.equals(this.instanceTerminationWaitTimeStarted(), other.instanceTerminationWaitTimeStarted()) && Objects.equals(this.blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration()) && Objects.equals(this.loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(this.additionalDeploymentStatusInfo(), other.additionalDeploymentStatusInfo()) && Objects.equals(this.fileExistsBehaviorString(), other.fileExistsBehaviorString());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentInfo").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("DeploymentId", (Object)this.deploymentId()).add("PreviousRevision", (Object)this.previousRevision()).add("Revision", (Object)this.revision()).add("Status", (Object)this.statusString()).add("ErrorInformation", (Object)this.errorInformation()).add("CreateTime", (Object)this.createTime()).add("StartTime", (Object)this.startTime()).add("CompleteTime", (Object)this.completeTime()).add("DeploymentOverview", (Object)this.deploymentOverview()).add("Description", (Object)this.description()).add("Creator", (Object)this.creatorString()).add("IgnoreApplicationStopFailures", (Object)this.ignoreApplicationStopFailures()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).add("UpdateOutdatedInstancesOnly", (Object)this.updateOutdatedInstancesOnly()).add("RollbackInfo", (Object)this.rollbackInfo()).add("DeploymentStyle", (Object)this.deploymentStyle()).add("TargetInstances", (Object)this.targetInstances()).add("InstanceTerminationWaitTimeStarted", (Object)this.instanceTerminationWaitTimeStarted()).add("BlueGreenDeploymentConfiguration", (Object)this.blueGreenDeploymentConfiguration()).add("LoadBalancerInfo", (Object)this.loadBalancerInfo()).add("AdditionalDeploymentStatusInfo", (Object)this.additionalDeploymentStatusInfo()).add("FileExistsBehavior", (Object)this.fileExistsBehaviorString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.of(clazz.cast(this.deploymentGroupName()));
            }
            case "deploymentConfigName": {
                return Optional.of(clazz.cast(this.deploymentConfigName()));
            }
            case "deploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "previousRevision": {
                return Optional.of(clazz.cast(this.previousRevision()));
            }
            case "revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
            case "status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
            case "errorInformation": {
                return Optional.of(clazz.cast(this.errorInformation()));
            }
            case "createTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "startTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "completeTime": {
                return Optional.of(clazz.cast(this.completeTime()));
            }
            case "deploymentOverview": {
                return Optional.of(clazz.cast(this.deploymentOverview()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "creator": {
                return Optional.of(clazz.cast(this.creatorString()));
            }
            case "ignoreApplicationStopFailures": {
                return Optional.of(clazz.cast(this.ignoreApplicationStopFailures()));
            }
            case "autoRollbackConfiguration": {
                return Optional.of(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "updateOutdatedInstancesOnly": {
                return Optional.of(clazz.cast(this.updateOutdatedInstancesOnly()));
            }
            case "rollbackInfo": {
                return Optional.of(clazz.cast(this.rollbackInfo()));
            }
            case "deploymentStyle": {
                return Optional.of(clazz.cast(this.deploymentStyle()));
            }
            case "targetInstances": {
                return Optional.of(clazz.cast(this.targetInstances()));
            }
            case "instanceTerminationWaitTimeStarted": {
                return Optional.of(clazz.cast(this.instanceTerminationWaitTimeStarted()));
            }
            case "blueGreenDeploymentConfiguration": {
                return Optional.of(clazz.cast(this.blueGreenDeploymentConfiguration()));
            }
            case "loadBalancerInfo": {
                return Optional.of(clazz.cast(this.loadBalancerInfo()));
            }
            case "additionalDeploymentStatusInfo": {
                return Optional.of(clazz.cast(this.additionalDeploymentStatusInfo()));
            }
            case "fileExistsBehavior": {
                return Optional.of(clazz.cast(this.fileExistsBehaviorString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private String deploymentId;
        private RevisionLocation previousRevision;
        private RevisionLocation revision;
        private String status;
        private ErrorInformation errorInformation;
        private Instant createTime;
        private Instant startTime;
        private Instant completeTime;
        private DeploymentOverview deploymentOverview;
        private String description;
        private String creator;
        private Boolean ignoreApplicationStopFailures;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private Boolean updateOutdatedInstancesOnly;
        private RollbackInfo rollbackInfo;
        private DeploymentStyle deploymentStyle;
        private TargetInstances targetInstances;
        private Boolean instanceTerminationWaitTimeStarted;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private String additionalDeploymentStatusInfo;
        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentInfo model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.deploymentConfigName(model.deploymentConfigName);
            this.deploymentId(model.deploymentId);
            this.previousRevision(model.previousRevision);
            this.revision(model.revision);
            this.status(model.status);
            this.errorInformation(model.errorInformation);
            this.createTime(model.createTime);
            this.startTime(model.startTime);
            this.completeTime(model.completeTime);
            this.deploymentOverview(model.deploymentOverview);
            this.description(model.description);
            this.creator(model.creator);
            this.ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            this.rollbackInfo(model.rollbackInfo);
            this.deploymentStyle(model.deploymentStyle);
            this.targetInstances(model.targetInstances);
            this.instanceTerminationWaitTimeStarted(model.instanceTerminationWaitTimeStarted);
            this.blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.loadBalancerInfo(model.loadBalancerInfo);
            this.additionalDeploymentStatusInfo(model.additionalDeploymentStatusInfo);
            this.fileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final RevisionLocation.Builder getPreviousRevision() {
            return this.previousRevision != null ? this.previousRevision.toBuilder() : null;
        }

        @Override
        public final Builder previousRevision(RevisionLocation previousRevision) {
            this.previousRevision = previousRevision;
            return this;
        }

        public final void setPreviousRevision(RevisionLocation.BuilderImpl previousRevision) {
            this.previousRevision = previousRevision != null ? previousRevision.build() : null;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ErrorInformation.Builder getErrorInformation() {
            return this.errorInformation != null ? this.errorInformation.toBuilder() : null;
        }

        @Override
        public final Builder errorInformation(ErrorInformation errorInformation) {
            this.errorInformation = errorInformation;
            return this;
        }

        public final void setErrorInformation(ErrorInformation.BuilderImpl errorInformation) {
            this.errorInformation = errorInformation != null ? errorInformation.build() : null;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getCompleteTime() {
            return this.completeTime;
        }

        @Override
        public final Builder completeTime(Instant completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final void setCompleteTime(Instant completeTime) {
            this.completeTime = completeTime;
        }

        public final DeploymentOverview.Builder getDeploymentOverview() {
            return this.deploymentOverview != null ? this.deploymentOverview.toBuilder() : null;
        }

        @Override
        public final Builder deploymentOverview(DeploymentOverview deploymentOverview) {
            this.deploymentOverview = deploymentOverview;
            return this;
        }

        public final void setDeploymentOverview(DeploymentOverview.BuilderImpl deploymentOverview) {
            this.deploymentOverview = deploymentOverview != null ? deploymentOverview.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getCreator() {
            return this.creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        @Override
        public final Builder creator(DeploymentCreator creator) {
            this.creator(creator.toString());
            return this;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return this.ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return this.updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        public final RollbackInfo.Builder getRollbackInfo() {
            return this.rollbackInfo != null ? this.rollbackInfo.toBuilder() : null;
        }

        @Override
        public final Builder rollbackInfo(RollbackInfo rollbackInfo) {
            this.rollbackInfo = rollbackInfo;
            return this;
        }

        public final void setRollbackInfo(RollbackInfo.BuilderImpl rollbackInfo) {
            this.rollbackInfo = rollbackInfo != null ? rollbackInfo.build() : null;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return this.deploymentStyle != null ? this.deploymentStyle.toBuilder() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return this.targetInstances != null ? this.targetInstances.toBuilder() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        public final Boolean getInstanceTerminationWaitTimeStarted() {
            return this.instanceTerminationWaitTimeStarted;
        }

        @Override
        public final Builder instanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
            return this;
        }

        public final void setInstanceTerminationWaitTimeStarted(Boolean instanceTerminationWaitTimeStarted) {
            this.instanceTerminationWaitTimeStarted = instanceTerminationWaitTimeStarted;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.build() : null;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return this.loadBalancerInfo != null ? this.loadBalancerInfo.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        public final String getAdditionalDeploymentStatusInfo() {
            return this.additionalDeploymentStatusInfo;
        }

        @Override
        public final Builder additionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
            return this;
        }

        public final void setAdditionalDeploymentStatusInfo(String additionalDeploymentStatusInfo) {
            this.additionalDeploymentStatusInfo = additionalDeploymentStatusInfo;
        }

        public final String getFileExistsBehavior() {
            return this.fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior.toString());
            return this;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        public DeploymentInfo build() {
            return new DeploymentInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentInfo> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder deploymentId(String var1);

        public Builder previousRevision(RevisionLocation var1);

        default public Builder previousRevision(Consumer<RevisionLocation.Builder> previousRevision) {
            return this.previousRevision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().apply(previousRevision)).build());
        }

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().apply(revision)).build());
        }

        public Builder status(String var1);

        public Builder status(DeploymentStatus var1);

        public Builder errorInformation(ErrorInformation var1);

        default public Builder errorInformation(Consumer<ErrorInformation.Builder> errorInformation) {
            return this.errorInformation((ErrorInformation)((ErrorInformation.Builder)ErrorInformation.builder().apply(errorInformation)).build());
        }

        public Builder createTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completeTime(Instant var1);

        public Builder deploymentOverview(DeploymentOverview var1);

        default public Builder deploymentOverview(Consumer<DeploymentOverview.Builder> deploymentOverview) {
            return this.deploymentOverview((DeploymentOverview)((DeploymentOverview.Builder)DeploymentOverview.builder().apply(deploymentOverview)).build());
        }

        public Builder description(String var1);

        public Builder creator(String var1);

        public Builder creator(DeploymentCreator var1);

        public Builder ignoreApplicationStopFailures(Boolean var1);

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().apply(autoRollbackConfiguration)).build());
        }

        public Builder updateOutdatedInstancesOnly(Boolean var1);

        public Builder rollbackInfo(RollbackInfo var1);

        default public Builder rollbackInfo(Consumer<RollbackInfo.Builder> rollbackInfo) {
            return this.rollbackInfo((RollbackInfo)((RollbackInfo.Builder)RollbackInfo.builder().apply(rollbackInfo)).build());
        }

        public Builder deploymentStyle(DeploymentStyle var1);

        default public Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return this.deploymentStyle((DeploymentStyle)((DeploymentStyle.Builder)DeploymentStyle.builder().apply(deploymentStyle)).build());
        }

        public Builder targetInstances(TargetInstances var1);

        default public Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return this.targetInstances((TargetInstances)((TargetInstances.Builder)TargetInstances.builder().apply(targetInstances)).build());
        }

        public Builder instanceTerminationWaitTimeStarted(Boolean var1);

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        default public Builder blueGreenDeploymentConfiguration(Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return this.blueGreenDeploymentConfiguration((BlueGreenDeploymentConfiguration)((BlueGreenDeploymentConfiguration.Builder)BlueGreenDeploymentConfiguration.builder().apply(blueGreenDeploymentConfiguration)).build());
        }

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        default public Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return this.loadBalancerInfo((LoadBalancerInfo)((LoadBalancerInfo.Builder)LoadBalancerInfo.builder().apply(loadBalancerInfo)).build());
        }

        public Builder additionalDeploymentStatusInfo(String var1);

        public Builder fileExistsBehavior(String var1);

        public Builder fileExistsBehavior(FileExistsBehavior var1);
    }
}

