/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentsResponse;

public final class ListDeploymentsPaginator
implements SdkIterable<ListDeploymentsResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDeploymentsPaginator(CodeDeployClient client, ListDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentsResponseFetcher();
    }

    public Iterator<ListDeploymentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<String> deployments() {
        Function<ListDeploymentsResponse, Iterator> getIterator = response -> response != null ? response.deployments().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListDeploymentsResponseFetcher
    implements NextPageFetcher<ListDeploymentsResponse> {
        private ListDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDeploymentsResponse nextPage(ListDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentsPaginator.this.client.listDeployments(ListDeploymentsPaginator.this.firstRequest);
            }
            return ListDeploymentsPaginator.this.client.listDeployments((ListDeploymentsRequest)((Object)ListDeploymentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

