/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListDeploymentsResponse> {
    private final List<String> deployments;
    private final String nextToken;

    private ListDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
        this.nextToken = builder.nextToken;
    }

    public List<String> deployments() {
        return this.deployments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deployments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsResponse)) {
            return false;
        }
        ListDeploymentsResponse other = (ListDeploymentsResponse)((Object)obj);
        return Objects.equals(this.deployments(), other.deployments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deployments() != null) {
            sb.append("Deployments: ").append(this.deployments()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deployments": {
                return Optional.of(clazz.cast(this.deployments()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<String> deployments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsResponse model) {
            this.deployments(model.deployments);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDeployments() {
            return this.deployments;
        }

        @Override
        public final Builder deployments(Collection<String> deployments) {
            this.deployments = DeploymentsListCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(String ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        public final void setDeployments(Collection<String> deployments) {
            this.deployments = DeploymentsListCopier.copy(deployments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentsResponse build() {
            return new ListDeploymentsResponse(this);
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    CopyableBuilder<Builder, ListDeploymentsResponse> {
        public Builder deployments(Collection<String> var1);

        public Builder deployments(String ... var1);

        public Builder nextToken(String var1);
    }
}

