/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.Tag;
import software.amazon.awssdk.services.codedeploy.model.TagListCopier;
import software.amazon.awssdk.services.codedeploy.transform.InstanceInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceInfo> {
    private final String instanceName;
    private final String iamSessionArn;
    private final String iamUserArn;
    private final String instanceArn;
    private final Instant registerTime;
    private final Instant deregisterTime;
    private final List<Tag> tags;

    private InstanceInfo(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
        this.instanceArn = builder.instanceArn;
        this.registerTime = builder.registerTime;
        this.deregisterTime = builder.deregisterTime;
        this.tags = builder.tags;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String iamSessionArn() {
        return this.iamSessionArn;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public Instant registerTime() {
        return this.registerTime;
    }

    public Instant deregisterTime() {
        return this.deregisterTime;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registerTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deregisterTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.iamSessionArn(), other.iamSessionArn()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.registerTime(), other.registerTime()) && Objects.equals(this.deregisterTime(), other.deregisterTime()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.iamSessionArn() != null) {
            sb.append("IamSessionArn: ").append(this.iamSessionArn()).append(",");
        }
        if (this.iamUserArn() != null) {
            sb.append("IamUserArn: ").append(this.iamUserArn()).append(",");
        }
        if (this.instanceArn() != null) {
            sb.append("InstanceArn: ").append(this.instanceArn()).append(",");
        }
        if (this.registerTime() != null) {
            sb.append("RegisterTime: ").append(this.registerTime()).append(",");
        }
        if (this.deregisterTime() != null) {
            sb.append("DeregisterTime: ").append(this.deregisterTime()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.of(clazz.cast(this.instanceName()));
            }
            case "iamSessionArn": {
                return Optional.of(clazz.cast(this.iamSessionArn()));
            }
            case "iamUserArn": {
                return Optional.of(clazz.cast(this.iamUserArn()));
            }
            case "instanceArn": {
                return Optional.of(clazz.cast(this.instanceArn()));
            }
            case "registerTime": {
                return Optional.of(clazz.cast(this.registerTime()));
            }
            case "deregisterTime": {
                return Optional.of(clazz.cast(this.deregisterTime()));
            }
            case "tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String iamSessionArn;
        private String iamUserArn;
        private String instanceArn;
        private Instant registerTime;
        private Instant deregisterTime;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            this.instanceName(model.instanceName);
            this.iamSessionArn(model.iamSessionArn);
            this.iamUserArn(model.iamUserArn);
            this.instanceArn(model.instanceArn);
            this.registerTime(model.registerTime);
            this.deregisterTime(model.deregisterTime);
            this.tags(model.tags);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return this.iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final Instant getRegisterTime() {
            return this.registerTime;
        }

        @Override
        public final Builder registerTime(Instant registerTime) {
            this.registerTime = registerTime;
            return this;
        }

        public final void setRegisterTime(Instant registerTime) {
            this.registerTime = registerTime;
        }

        public final Instant getDeregisterTime() {
            return this.deregisterTime;
        }

        @Override
        public final Builder deregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
            return this;
        }

        public final void setDeregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public InstanceInfo build() {
            return new InstanceInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceInfo> {
        public Builder instanceName(String var1);

        public Builder iamSessionArn(String var1);

        public Builder iamUserArn(String var1);

        public Builder instanceArn(String var1);

        public Builder registerTime(Instant var1);

        public Builder deregisterTime(Instant var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

