/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSetListCopier;
import software.amazon.awssdk.services.codedeploy.transform.EC2TagSetMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EC2TagSet
implements StructuredPojo,
ToCopyableBuilder<Builder, EC2TagSet> {
    private final List<List<EC2TagFilter>> ec2TagSetList;

    private EC2TagSet(BuilderImpl builder) {
        this.ec2TagSetList = builder.ec2TagSetList;
    }

    public List<List<EC2TagFilter>> ec2TagSetList() {
        return this.ec2TagSetList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagSetList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2TagSet)) {
            return false;
        }
        EC2TagSet other = (EC2TagSet)obj;
        return Objects.equals(this.ec2TagSetList(), other.ec2TagSetList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.ec2TagSetList() != null) {
            sb.append("Ec2TagSetList: ").append(this.ec2TagSetList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ec2TagSetList": {
                return Optional.of(clazz.cast(this.ec2TagSetList()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EC2TagSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<List<EC2TagFilter>> ec2TagSetList;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2TagSet model) {
            this.ec2TagSetList(model.ec2TagSetList);
        }

        public final Collection<? extends Collection<EC2TagFilter>> getEc2TagSetList() {
            return this.ec2TagSetList;
        }

        @Override
        public final Builder ec2TagSetList(Collection<? extends Collection<EC2TagFilter>> ec2TagSetList) {
            this.ec2TagSetList = EC2TagSetListCopier.copy(ec2TagSetList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagSetList(Collection<EC2TagFilter> ... ec2TagSetList) {
            this.ec2TagSetList((Collection<? extends Collection<EC2TagFilter>>)Arrays.asList(ec2TagSetList));
            return this;
        }

        public final void setEc2TagSetList(Collection<? extends Collection<EC2TagFilter>> ec2TagSetList) {
            this.ec2TagSetList = EC2TagSetListCopier.copy(ec2TagSetList);
        }

        public EC2TagSet build() {
            return new EC2TagSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EC2TagSet> {
        public Builder ec2TagSetList(Collection<? extends Collection<EC2TagFilter>> var1);

        public Builder ec2TagSetList(Collection<EC2TagFilter> ... var1);
    }
}

