/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.ApplicationsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetApplicationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetApplicationsRequest> {
    private final List<String> applicationNames;

    private BatchGetApplicationsRequest(BuilderImpl builder) {
        this.applicationNames = builder.applicationNames;
    }

    public List<String> applicationNames() {
        return this.applicationNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationsRequest)) {
            return false;
        }
        BatchGetApplicationsRequest other = (BatchGetApplicationsRequest)((Object)obj);
        return Objects.equals(this.applicationNames(), other.applicationNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationNames() != null) {
            sb.append("ApplicationNames: ").append(this.applicationNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationNames": {
                return Optional.of(clazz.cast(this.applicationNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> applicationNames;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationsRequest model) {
            this.applicationNames(model.applicationNames);
        }

        public final Collection<String> getApplicationNames() {
            return this.applicationNames;
        }

        @Override
        public final Builder applicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationsListCopier.copy(applicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationNames(String ... applicationNames) {
            this.applicationNames(Arrays.asList(applicationNames));
            return this;
        }

        public final void setApplicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationsListCopier.copy(applicationNames);
        }

        public BatchGetApplicationsRequest build() {
            return new BatchGetApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetApplicationsRequest> {
        public Builder applicationNames(Collection<String> var1);

        public Builder applicationNames(String ... var1);
    }
}

