/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopDeploymentRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StopDeploymentRequest> {
    private final String deploymentId;
    private final Boolean autoRollbackEnabled;

    private StopDeploymentRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.autoRollbackEnabled = builder.autoRollbackEnabled;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public Boolean autoRollbackEnabled() {
        return this.autoRollbackEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentId() == null ? 0 : this.deploymentId().hashCode());
        hashCode = 31 * hashCode + (this.autoRollbackEnabled() == null ? 0 : this.autoRollbackEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDeploymentRequest)) {
            return false;
        }
        StopDeploymentRequest other = (StopDeploymentRequest)((Object)obj);
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.autoRollbackEnabled() == null ^ this.autoRollbackEnabled() == null) {
            return false;
        }
        return other.autoRollbackEnabled() == null || other.autoRollbackEnabled().equals(this.autoRollbackEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentId() != null) {
            sb.append("DeploymentId: ").append(this.deploymentId()).append(",");
        }
        if (this.autoRollbackEnabled() != null) {
            sb.append("AutoRollbackEnabled: ").append(this.autoRollbackEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.of(clazz.cast(this.deploymentId()));
            }
            case "autoRollbackEnabled": {
                return Optional.of(clazz.cast(this.autoRollbackEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private Boolean autoRollbackEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDeploymentRequest model) {
            this.deploymentId(model.deploymentId);
            this.autoRollbackEnabled(model.autoRollbackEnabled);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final Boolean getAutoRollbackEnabled() {
            return this.autoRollbackEnabled;
        }

        @Override
        public final Builder autoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
            return this;
        }

        public final void setAutoRollbackEnabled(Boolean autoRollbackEnabled) {
            this.autoRollbackEnabled = autoRollbackEnabled;
        }

        public StopDeploymentRequest build() {
            return new StopDeploymentRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StopDeploymentRequest> {
        public Builder deploymentId(String var1);

        public Builder autoRollbackEnabled(Boolean var1);
    }
}

