/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatus;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStatusListCopier;
import software.amazon.awssdk.services.codedeploy.model.TimeRange;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListDeploymentsRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final List<String> includeOnlyStatuses;
    private final TimeRange createTimeRange;
    private final String nextToken;

    private ListDeploymentsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.includeOnlyStatuses = builder.includeOnlyStatuses;
        this.createTimeRange = builder.createTimeRange;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public List<DeploymentStatus> includeOnlyStatuses() {
        return TypeConverter.convert(this.includeOnlyStatuses, DeploymentStatus::fromValue);
    }

    public List<String> includeOnlyStatusesStrings() {
        return this.includeOnlyStatuses;
    }

    public TimeRange createTimeRange() {
        return this.createTimeRange;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroupName() == null ? 0 : this.deploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.includeOnlyStatusesStrings() == null ? 0 : this.includeOnlyStatusesStrings().hashCode());
        hashCode = 31 * hashCode + (this.createTimeRange() == null ? 0 : this.createTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroupName() == null ^ this.deploymentGroupName() == null) {
            return false;
        }
        if (other.deploymentGroupName() != null && !other.deploymentGroupName().equals(this.deploymentGroupName())) {
            return false;
        }
        if (other.includeOnlyStatusesStrings() == null ^ this.includeOnlyStatusesStrings() == null) {
            return false;
        }
        if (other.includeOnlyStatusesStrings() != null && !other.includeOnlyStatusesStrings().equals(this.includeOnlyStatusesStrings())) {
            return false;
        }
        if (other.createTimeRange() == null ^ this.createTimeRange() == null) {
            return false;
        }
        if (other.createTimeRange() != null && !other.createTimeRange().equals(this.createTimeRange())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.includeOnlyStatusesStrings() != null) {
            sb.append("IncludeOnlyStatuses: ").append(this.includeOnlyStatusesStrings()).append(",");
        }
        if (this.createTimeRange() != null) {
            sb.append("CreateTimeRange: ").append(this.createTimeRange()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.of(clazz.cast(this.deploymentGroupName()));
            }
            case "includeOnlyStatuses": {
                return Optional.of(clazz.cast(this.includeOnlyStatusesStrings()));
            }
            case "createTimeRange": {
                return Optional.of(clazz.cast(this.createTimeRange()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private List<String> includeOnlyStatuses;
        private TimeRange createTimeRange;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentsRequest model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.includeOnlyStatuses(model.includeOnlyStatuses);
            this.createTimeRange(model.createTimeRange);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final Collection<String> getIncludeOnlyStatuses() {
            return this.includeOnlyStatuses;
        }

        @Override
        public final Builder includeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeOnlyStatuses(String ... includeOnlyStatuses) {
            this.includeOnlyStatuses(Arrays.asList(includeOnlyStatuses));
            return this;
        }

        public final void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
            this.includeOnlyStatuses = DeploymentStatusListCopier.copy(includeOnlyStatuses);
        }

        public final TimeRange.Builder getCreateTimeRange() {
            return this.createTimeRange != null ? this.createTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder createTimeRange(TimeRange createTimeRange) {
            this.createTimeRange = createTimeRange;
            return this;
        }

        public final void setCreateTimeRange(TimeRange.BuilderImpl createTimeRange) {
            this.createTimeRange = createTimeRange != null ? createTimeRange.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDeploymentsRequest build() {
            return new ListDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentsRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder includeOnlyStatuses(Collection<String> var1);

        public Builder includeOnlyStatuses(String ... var1);

        public Builder createTimeRange(TimeRange var1);

        public Builder nextToken(String var1);
    }
}

