/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetApplicationRevisionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetApplicationRevisionRequest> {
    private final String applicationName;
    private final RevisionLocation revision;

    private GetApplicationRevisionRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.revision = builder.revision;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.revision() == null ? 0 : this.revision().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRevisionRequest)) {
            return false;
        }
        GetApplicationRevisionRequest other = (GetApplicationRevisionRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.revision() == null ^ this.revision() == null) {
            return false;
        }
        return other.revision() == null || other.revision().equals(this.revision());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.revision() != null) {
            sb.append("Revision: ").append(this.revision()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private RevisionLocation revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRevisionRequest model) {
            this.applicationName(model.applicationName);
            this.revision(model.revision);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        public GetApplicationRevisionRequest build() {
            return new GetApplicationRevisionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetApplicationRevisionRequest> {
        public Builder applicationName(String var1);

        public Builder revision(RevisionLocation var1);
    }
}

