/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.InstanceSummary;
import software.amazon.awssdk.services.codedeploy.model.InstanceSummaryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetDeploymentInstancesResponse> {
    private final List<InstanceSummary> instancesSummary;
    private final String errorMessage;

    private BatchGetDeploymentInstancesResponse(BuilderImpl builder) {
        this.instancesSummary = builder.instancesSummary;
        this.errorMessage = builder.errorMessage;
    }

    public List<InstanceSummary> instancesSummary() {
        return this.instancesSummary;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instancesSummary() == null ? 0 : this.instancesSummary().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentInstancesResponse)) {
            return false;
        }
        BatchGetDeploymentInstancesResponse other = (BatchGetDeploymentInstancesResponse)((Object)obj);
        if (other.instancesSummary() == null ^ this.instancesSummary() == null) {
            return false;
        }
        if (other.instancesSummary() != null && !other.instancesSummary().equals(this.instancesSummary())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.instancesSummary() != null) {
            sb.append("InstancesSummary: ").append(this.instancesSummary()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instancesSummary": {
                return Optional.of(clazz.cast(this.instancesSummary()));
            }
            case "errorMessage": {
                return Optional.of(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<InstanceSummary> instancesSummary;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentInstancesResponse model) {
            this.instancesSummary(model.instancesSummary);
            this.errorMessage(model.errorMessage);
        }

        public final Collection<InstanceSummary.Builder> getInstancesSummary() {
            return this.instancesSummary != null ? (Collection)this.instancesSummary.stream().map(InstanceSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instancesSummary(Collection<InstanceSummary> instancesSummary) {
            this.instancesSummary = InstanceSummaryListCopier.copy(instancesSummary);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesSummary(InstanceSummary ... instancesSummary) {
            this.instancesSummary(Arrays.asList(instancesSummary));
            return this;
        }

        public final void setInstancesSummary(Collection<InstanceSummary.BuilderImpl> instancesSummary) {
            this.instancesSummary = InstanceSummaryListCopier.copyFromBuilder(instancesSummary);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public BatchGetDeploymentInstancesResponse build() {
            return new BatchGetDeploymentInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetDeploymentInstancesResponse> {
        public Builder instancesSummary(Collection<InstanceSummary> var1);

        public Builder instancesSummary(InstanceSummary ... var1);

        public Builder errorMessage(String var1);
    }
}

