/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private final String applicationName;
    private final String newApplicationName;

    private UpdateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.newApplicationName = builder.newApplicationName;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String newApplicationName() {
        return this.newApplicationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.newApplicationName() == null ? 0 : this.newApplicationName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.newApplicationName() == null ^ this.newApplicationName() == null) {
            return false;
        }
        return other.newApplicationName() == null || other.newApplicationName().equals(this.newApplicationName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.newApplicationName() != null) {
            sb.append("NewApplicationName: ").append(this.newApplicationName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String newApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            this.setApplicationName(model.applicationName);
            this.setNewApplicationName(model.newApplicationName);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getNewApplicationName() {
            return this.newApplicationName;
        }

        @Override
        public final Builder newApplicationName(String newApplicationName) {
            this.newApplicationName = newApplicationName;
            return this;
        }

        public final void setNewApplicationName(String newApplicationName) {
            this.newApplicationName = newApplicationName;
        }

        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder newApplicationName(String var1);
    }
}

