/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetApplicationRevisionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
    private final String applicationName;
    private final String errorMessage;
    private final List<RevisionInfo> revisions;

    private BatchGetApplicationRevisionsResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.errorMessage = builder.errorMessage;
        this.revisions = builder.revisions;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<RevisionInfo> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        hashCode = 31 * hashCode + (this.revisions() == null ? 0 : this.revisions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsResponse)) {
            return false;
        }
        BatchGetApplicationRevisionsResponse other = (BatchGetApplicationRevisionsResponse)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        if (other.revisions() == null ^ this.revisions() == null) {
            return false;
        }
        return other.revisions() == null || other.revisions().equals(this.revisions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        if (this.revisions() != null) {
            sb.append("Revisions: ").append(this.revisions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String errorMessage;
        private List<RevisionInfo> revisions;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsResponse model) {
            this.setApplicationName(model.applicationName);
            this.setErrorMessage(model.errorMessage);
            this.setRevisions(model.revisions);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Collection<RevisionInfo> getRevisions() {
            return this.revisions;
        }

        @Override
        public final Builder revisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionInfo ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        public final void setRevisions(Collection<RevisionInfo> revisions) {
            this.revisions = RevisionInfoListCopier.copy(revisions);
        }

        public BatchGetApplicationRevisionsResponse build() {
            return new BatchGetApplicationRevisionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetApplicationRevisionsResponse> {
        public Builder applicationName(String var1);

        public Builder errorMessage(String var1);

        public Builder revisions(Collection<RevisionInfo> var1);

        public Builder revisions(RevisionInfo ... var1);
    }
}

