/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.BundleType;
import software.amazon.awssdk.services.codedeploy.transform.S3LocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class S3Location
implements StructuredPojo,
ToCopyableBuilder<Builder, S3Location> {
    private final String bucket;
    private final String key;
    private final String bundleType;
    private final String version;
    private final String eTag;

    private S3Location(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.bundleType = builder.bundleType;
        this.version = builder.version;
        this.eTag = builder.eTag;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String bundleType() {
        return this.bundleType;
    }

    public String version() {
        return this.version;
    }

    public String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.bundleType() == null ? 0 : this.bundleType().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        hashCode = 31 * hashCode + (this.eTag() == null ? 0 : this.eTag().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.bundleType() == null ^ this.bundleType() == null) {
            return false;
        }
        if (other.bundleType() != null && !other.bundleType().equals(this.bundleType())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        if (other.version() != null && !other.version().equals(this.version())) {
            return false;
        }
        if (other.eTag() == null ^ this.eTag() == null) {
            return false;
        }
        return other.eTag() == null || other.eTag().equals(this.eTag());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.bundleType() != null) {
            sb.append("BundleType: ").append(this.bundleType()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (this.eTag() != null) {
            sb.append("ETag: ").append(this.eTag()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3LocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private String bundleType;
        private String version;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            this.setBucket(model.bucket);
            this.setKey(model.key);
            this.setBundleType(model.bundleType);
            this.setVersion(model.version);
            this.setETag(model.eTag);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getBundleType() {
            return this.bundleType;
        }

        @Override
        public final Builder bundleType(String bundleType) {
            this.bundleType = bundleType;
            return this;
        }

        @Override
        public final Builder bundleType(BundleType bundleType) {
            this.bundleType(bundleType.toString());
            return this;
        }

        public final void setBundleType(String bundleType) {
            this.bundleType = bundleType;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public S3Location build() {
            return new S3Location(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, S3Location> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder bundleType(String var1);

        public Builder bundleType(BundleType var1);

        public Builder version(String var1);

        public Builder eTag(String var1);
    }
}

