/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDeploymentGroupsResponse> {
    private final String applicationName;
    private final List<String> deploymentGroups;
    private final String nextToken;

    private ListDeploymentGroupsResponse(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroups = builder.deploymentGroups;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<String> deploymentGroups() {
        return this.deploymentGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroups() == null ? 0 : this.deploymentGroups().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentGroupsResponse)) {
            return false;
        }
        ListDeploymentGroupsResponse other = (ListDeploymentGroupsResponse)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.deploymentGroups() == null ^ this.deploymentGroups() == null) {
            return false;
        }
        if (other.deploymentGroups() != null && !other.deploymentGroups().equals(this.deploymentGroups())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroups() != null) {
            sb.append("DeploymentGroups: ").append(this.deploymentGroups()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private List<String> deploymentGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentGroupsResponse model) {
            this.setApplicationName(model.applicationName);
            this.setDeploymentGroups(model.deploymentGroups);
            this.setNextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroups() {
            return this.deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String ... deploymentGroups) {
            this.deploymentGroups(Arrays.asList(deploymentGroups));
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDeploymentGroupsResponse build() {
            return new ListDeploymentGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentGroupsResponse> {
        public Builder applicationName(String var1);

        public Builder deploymentGroups(Collection<String> var1);

        public Builder deploymentGroups(String ... var1);

        public Builder nextToken(String var1);
    }
}

