/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.InstanceAction;
import software.amazon.awssdk.services.codedeploy.transform.BlueInstanceTerminationOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BlueInstanceTerminationOption
implements StructuredPojo,
ToCopyableBuilder<Builder, BlueInstanceTerminationOption> {
    private final String action;
    private final Integer terminationWaitTimeInMinutes;

    private BlueInstanceTerminationOption(BuilderImpl builder) {
        this.action = builder.action;
        this.terminationWaitTimeInMinutes = builder.terminationWaitTimeInMinutes;
    }

    public String action() {
        return this.action;
    }

    public Integer terminationWaitTimeInMinutes() {
        return this.terminationWaitTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.terminationWaitTimeInMinutes() == null ? 0 : this.terminationWaitTimeInMinutes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueInstanceTerminationOption)) {
            return false;
        }
        BlueInstanceTerminationOption other = (BlueInstanceTerminationOption)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.terminationWaitTimeInMinutes() == null ^ this.terminationWaitTimeInMinutes() == null) {
            return false;
        }
        return other.terminationWaitTimeInMinutes() == null || other.terminationWaitTimeInMinutes().equals(this.terminationWaitTimeInMinutes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.terminationWaitTimeInMinutes() != null) {
            sb.append("TerminationWaitTimeInMinutes: ").append(this.terminationWaitTimeInMinutes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlueInstanceTerminationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private Integer terminationWaitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueInstanceTerminationOption model) {
            this.setAction(model.action);
            this.setTerminationWaitTimeInMinutes(model.terminationWaitTimeInMinutes);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(InstanceAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getTerminationWaitTimeInMinutes() {
            return this.terminationWaitTimeInMinutes;
        }

        @Override
        public final Builder terminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
            return this;
        }

        public final void setTerminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
        }

        public BlueInstanceTerminationOption build() {
            return new BlueInstanceTerminationOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlueInstanceTerminationOption> {
        public Builder action(String var1);

        public Builder action(InstanceAction var1);

        public Builder terminationWaitTimeInMinutes(Integer var1);
    }
}

