/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.ApplicationsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetApplicationsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetApplicationsRequest> {
    private final List<String> applicationNames;

    private BatchGetApplicationsRequest(BuilderImpl builder) {
        this.applicationNames = builder.applicationNames;
    }

    public List<String> applicationNames() {
        return this.applicationNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationNames() == null ? 0 : this.applicationNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationsRequest)) {
            return false;
        }
        BatchGetApplicationsRequest other = (BatchGetApplicationsRequest)((Object)obj);
        if (other.applicationNames() == null ^ this.applicationNames() == null) {
            return false;
        }
        return other.applicationNames() == null || other.applicationNames().equals(this.applicationNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationNames() != null) {
            sb.append("ApplicationNames: ").append(this.applicationNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> applicationNames;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationsRequest model) {
            this.setApplicationNames(model.applicationNames);
        }

        public final Collection<String> getApplicationNames() {
            return this.applicationNames;
        }

        @Override
        public final Builder applicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationsListCopier.copy(applicationNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationNames(String ... applicationNames) {
            this.applicationNames(Arrays.asList(applicationNames));
            return this;
        }

        public final void setApplicationNames(Collection<String> applicationNames) {
            this.applicationNames = ApplicationsListCopier.copy(applicationNames);
        }

        public BatchGetApplicationsRequest build() {
            return new BatchGetApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetApplicationsRequest> {
        public Builder applicationNames(Collection<String> var1);

        public Builder applicationNames(String ... var1);
    }
}

