/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.codedeploy.model.InstancesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDeploymentInstancesResponse> {
    private final List<String> instancesList;
    private final String nextToken;

    private ListDeploymentInstancesResponse(BuilderImpl builder) {
        this.instancesList = builder.instancesList;
        this.nextToken = builder.nextToken;
    }

    public List<String> instancesList() {
        return this.instancesList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instancesList() == null ? 0 : this.instancesList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentInstancesResponse)) {
            return false;
        }
        ListDeploymentInstancesResponse other = (ListDeploymentInstancesResponse)((Object)obj);
        if (other.instancesList() == null ^ this.instancesList() == null) {
            return false;
        }
        if (other.instancesList() != null && !other.instancesList().equals(this.instancesList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instancesList() != null) {
            sb.append("InstancesList: ").append(this.instancesList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instancesList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentInstancesResponse model) {
            this.setInstancesList(model.instancesList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getInstancesList() {
            return this.instancesList;
        }

        @Override
        public final Builder instancesList(Collection<String> instancesList) {
            this.instancesList = InstancesListCopier.copy(instancesList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesList(String ... instancesList) {
            this.instancesList(Arrays.asList(instancesList));
            return this;
        }

        public final void setInstancesList(Collection<String> instancesList) {
            this.instancesList = InstancesListCopier.copy(instancesList);
        }

        @SafeVarargs
        public final void setInstancesList(String ... instancesList) {
            this.instancesList(Arrays.asList(instancesList));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDeploymentInstancesResponse build() {
            return new ListDeploymentInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDeploymentInstancesResponse> {
        public Builder instancesList(Collection<String> var1);

        public Builder instancesList(String ... var1);

        public Builder nextToken(String var1);
    }
}

