/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy;
import software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction;
import software.amazon.awssdk.services.codedeploy.model.SortOrder;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationRevisionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListApplicationRevisionsRequest> {
    private final String applicationName;
    private final String sortBy;
    private final String sortOrder;
    private final String s3Bucket;
    private final String s3KeyPrefix;
    private final String deployed;
    private final String nextToken;

    private ListApplicationRevisionsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.deployed = builder.deployed;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String sortBy() {
        return this.sortBy;
    }

    public String sortOrder() {
        return this.sortOrder;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public String deployed() {
        return this.deployed;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.sortBy() == null ? 0 : this.sortBy().hashCode());
        hashCode = 31 * hashCode + (this.sortOrder() == null ? 0 : this.sortOrder().hashCode());
        hashCode = 31 * hashCode + (this.s3Bucket() == null ? 0 : this.s3Bucket().hashCode());
        hashCode = 31 * hashCode + (this.s3KeyPrefix() == null ? 0 : this.s3KeyPrefix().hashCode());
        hashCode = 31 * hashCode + (this.deployed() == null ? 0 : this.deployed().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsRequest)) {
            return false;
        }
        ListApplicationRevisionsRequest other = (ListApplicationRevisionsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.sortBy() == null ^ this.sortBy() == null) {
            return false;
        }
        if (other.sortBy() != null && !other.sortBy().equals(this.sortBy())) {
            return false;
        }
        if (other.sortOrder() == null ^ this.sortOrder() == null) {
            return false;
        }
        if (other.sortOrder() != null && !other.sortOrder().equals(this.sortOrder())) {
            return false;
        }
        if (other.s3Bucket() == null ^ this.s3Bucket() == null) {
            return false;
        }
        if (other.s3Bucket() != null && !other.s3Bucket().equals(this.s3Bucket())) {
            return false;
        }
        if (other.s3KeyPrefix() == null ^ this.s3KeyPrefix() == null) {
            return false;
        }
        if (other.s3KeyPrefix() != null && !other.s3KeyPrefix().equals(this.s3KeyPrefix())) {
            return false;
        }
        if (other.deployed() == null ^ this.deployed() == null) {
            return false;
        }
        if (other.deployed() != null && !other.deployed().equals(this.deployed())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.sortBy() != null) {
            sb.append("SortBy: ").append(this.sortBy()).append(",");
        }
        if (this.sortOrder() != null) {
            sb.append("SortOrder: ").append(this.sortOrder()).append(",");
        }
        if (this.s3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.s3Bucket()).append(",");
        }
        if (this.s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.s3KeyPrefix()).append(",");
        }
        if (this.deployed() != null) {
            sb.append("Deployed: ").append(this.deployed()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String sortBy;
        private String sortOrder;
        private String s3Bucket;
        private String s3KeyPrefix;
        private String deployed;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsRequest model) {
            this.setApplicationName(model.applicationName);
            this.setSortBy(model.sortBy);
            this.setSortOrder(model.sortOrder);
            this.setS3Bucket(model.s3Bucket);
            this.setS3KeyPrefix(model.s3KeyPrefix);
            this.setDeployed(model.deployed);
            this.setNextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ApplicationRevisionSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final void setSortBy(ApplicationRevisionSortBy sortBy) {
            this.sortBy(sortBy.toString());
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final void setSortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(String deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public final Builder deployed(ListStateFilterAction deployed) {
            this.deployed(deployed.toString());
            return this;
        }

        public final void setDeployed(String deployed) {
            this.deployed = deployed;
        }

        public final void setDeployed(ListStateFilterAction deployed) {
            this.deployed(deployed.toString());
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListApplicationRevisionsRequest build() {
            return new ListApplicationRevisionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListApplicationRevisionsRequest> {
        public Builder applicationName(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ApplicationRevisionSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder s3Bucket(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder deployed(String var1);

        public Builder deployed(ListStateFilterAction var1);

        public Builder nextToken(String var1);
    }
}

