/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetApplicationRevisionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetApplicationRevisionsRequest> {
    private final String applicationName;
    private final List<RevisionLocation> revisions;

    private BatchGetApplicationRevisionsRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.revisions = builder.revisions;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<RevisionLocation> revisions() {
        return this.revisions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.revisions() == null ? 0 : this.revisions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetApplicationRevisionsRequest)) {
            return false;
        }
        BatchGetApplicationRevisionsRequest other = (BatchGetApplicationRevisionsRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.revisions() == null ^ this.revisions() == null) {
            return false;
        }
        return other.revisions() == null || other.revisions().equals(this.revisions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.revisions() != null) {
            sb.append("Revisions: ").append(this.revisions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private List<RevisionLocation> revisions;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetApplicationRevisionsRequest model) {
            this.setApplicationName(model.applicationName);
            this.setRevisions(model.revisions);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<RevisionLocation> getRevisions() {
            return this.revisions;
        }

        @Override
        public final Builder revisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisions(RevisionLocation ... revisions) {
            this.revisions(Arrays.asList(revisions));
            return this;
        }

        public final void setRevisions(Collection<RevisionLocation> revisions) {
            this.revisions = RevisionLocationListCopier.copy(revisions);
        }

        @SafeVarargs
        public final void setRevisions(RevisionLocation ... revisions) {
            this.revisions(Arrays.asList(revisions));
        }

        public BatchGetApplicationRevisionsRequest build() {
            return new BatchGetApplicationRevisionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetApplicationRevisionsRequest> {
        public Builder applicationName(String var1);

        public Builder revisions(Collection<RevisionLocation> var1);

        public Builder revisions(RevisionLocation ... var1);
    }
}

