/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.GitHubLocation;
import software.amazon.awssdk.services.codedeploy.model.RawString;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocationType;
import software.amazon.awssdk.services.codedeploy.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevisionLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RevisionLocation> {
    private static final SdkField<String> REVISION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RevisionLocation.getter(RevisionLocation::revisionTypeAsString)).setter(RevisionLocation.setter(Builder::revisionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionType").build()}).build();
    private static final SdkField<S3Location> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RevisionLocation.getter(RevisionLocation::s3Location)).setter(RevisionLocation.setter(Builder::s3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final SdkField<GitHubLocation> GIT_HUB_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RevisionLocation.getter(RevisionLocation::gitHubLocation)).setter(RevisionLocation.setter(Builder::gitHubLocation)).constructor(GitHubLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gitHubLocation").build()}).build();
    private static final SdkField<RawString> STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RevisionLocation.getter(RevisionLocation::string)).setter(RevisionLocation.setter(Builder::string)).constructor(RawString::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("string").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVISION_TYPE_FIELD, S3_LOCATION_FIELD, GIT_HUB_LOCATION_FIELD, STRING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String revisionType;
    private final S3Location s3Location;
    private final GitHubLocation gitHubLocation;
    private final RawString string;

    private RevisionLocation(BuilderImpl builder) {
        this.revisionType = builder.revisionType;
        this.s3Location = builder.s3Location;
        this.gitHubLocation = builder.gitHubLocation;
        this.string = builder.string;
    }

    public RevisionLocationType revisionType() {
        return RevisionLocationType.fromValue(this.revisionType);
    }

    public String revisionTypeAsString() {
        return this.revisionType;
    }

    public S3Location s3Location() {
        return this.s3Location;
    }

    public GitHubLocation gitHubLocation() {
        return this.gitHubLocation;
    }

    public RawString string() {
        return this.string;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitHubLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.string());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionLocation)) {
            return false;
        }
        RevisionLocation other = (RevisionLocation)obj;
        return Objects.equals(this.revisionTypeAsString(), other.revisionTypeAsString()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.gitHubLocation(), other.gitHubLocation()) && Objects.equals(this.string(), other.string());
    }

    public String toString() {
        return ToString.builder((String)"RevisionLocation").add("RevisionType", (Object)this.revisionTypeAsString()).add("S3Location", (Object)this.s3Location()).add("GitHubLocation", (Object)this.gitHubLocation()).add("String", (Object)this.string()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionType": {
                return Optional.ofNullable(clazz.cast(this.revisionTypeAsString()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "gitHubLocation": {
                return Optional.ofNullable(clazz.cast(this.gitHubLocation()));
            }
            case "string": {
                return Optional.ofNullable(clazz.cast(this.string()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RevisionLocation, T> g) {
        return obj -> g.apply((RevisionLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String revisionType;
        private S3Location s3Location;
        private GitHubLocation gitHubLocation;
        private RawString string;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionLocation model) {
            this.revisionType(model.revisionType);
            this.s3Location(model.s3Location);
            this.gitHubLocation(model.gitHubLocation);
            this.string(model.string);
        }

        public final String getRevisionType() {
            return this.revisionType;
        }

        @Override
        public final Builder revisionType(String revisionType) {
            this.revisionType = revisionType;
            return this;
        }

        @Override
        public final Builder revisionType(RevisionLocationType revisionType) {
            this.revisionType(revisionType.toString());
            return this;
        }

        public final void setRevisionType(String revisionType) {
            this.revisionType = revisionType;
        }

        public final S3Location.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        @Override
        public final Builder s3Location(S3Location s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final void setS3Location(S3Location.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        public final GitHubLocation.Builder getGitHubLocation() {
            return this.gitHubLocation != null ? this.gitHubLocation.toBuilder() : null;
        }

        @Override
        public final Builder gitHubLocation(GitHubLocation gitHubLocation) {
            this.gitHubLocation = gitHubLocation;
            return this;
        }

        public final void setGitHubLocation(GitHubLocation.BuilderImpl gitHubLocation) {
            this.gitHubLocation = gitHubLocation != null ? gitHubLocation.build() : null;
        }

        public final RawString.Builder getString() {
            return this.string != null ? this.string.toBuilder() : null;
        }

        @Override
        public final Builder string(RawString string) {
            this.string = string;
            return this;
        }

        public final void setString(RawString.BuilderImpl string) {
            this.string = string != null ? string.build() : null;
        }

        public RevisionLocation build() {
            return new RevisionLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RevisionLocation> {
        public Builder revisionType(String var1);

        public Builder revisionType(RevisionLocationType var1);

        public Builder s3Location(S3Location var1);

        default public Builder s3Location(Consumer<S3Location.Builder> s3Location) {
            return this.s3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(s3Location)).build());
        }

        public Builder gitHubLocation(GitHubLocation var1);

        default public Builder gitHubLocation(Consumer<GitHubLocation.Builder> gitHubLocation) {
            return this.gitHubLocation((GitHubLocation)((GitHubLocation.Builder)GitHubLocation.builder().applyMutation(gitHubLocation)).build());
        }

        public Builder string(RawString var1);

        default public Builder string(Consumer<RawString.Builder> string) {
            return this.string((RawString)((RawString.Builder)RawString.builder().applyMutation(string)).build());
        }
    }
}

