/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.InstanceStatus;
import software.amazon.awssdk.services.codedeploy.model.InstanceType;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceSummary> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceSummary.getter(InstanceSummary::deploymentId)).setter(InstanceSummary.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceSummary.getter(InstanceSummary::instanceId)).setter(InstanceSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceSummary.getter(InstanceSummary::statusAsString)).setter(InstanceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(InstanceSummary.getter(InstanceSummary::lastUpdatedAt)).setter(InstanceSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<List<LifecycleEvent>> LIFECYCLE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceSummary.getter(InstanceSummary::lifecycleEvents)).setter(InstanceSummary.setter(Builder::lifecycleEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceSummary.getter(InstanceSummary::instanceTypeAsString)).setter(InstanceSummary.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, INSTANCE_ID_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_EVENTS_FIELD, INSTANCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String instanceId;
    private final String status;
    private final Instant lastUpdatedAt;
    private final List<LifecycleEvent> lifecycleEvents;
    private final String instanceType;

    private InstanceSummary(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.instanceType = builder.instanceType;
    }

    public String deploymentId() {
        return this.deploymentId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public InstanceStatus status() {
        return InstanceStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public List<LifecycleEvent> lifecycleEvents() {
        return this.lifecycleEvents;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEvents());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceSummary)) {
            return false;
        }
        InstanceSummary other = (InstanceSummary)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.lifecycleEvents(), other.lifecycleEvents()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"InstanceSummary").add("DeploymentId", (Object)this.deploymentId()).add("InstanceId", (Object)this.instanceId()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleEvents", this.lifecycleEvents()).add("InstanceType", (Object)this.instanceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "instanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleEvents": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEvents()));
            }
            case "instanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceSummary, T> g) {
        return obj -> g.apply((InstanceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String instanceId;
        private String status;
        private Instant lastUpdatedAt;
        private List<LifecycleEvent> lifecycleEvents = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceSummary model) {
            this.deploymentId(model.deploymentId);
            this.instanceId(model.instanceId);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleEvents(model.lifecycleEvents);
            this.instanceType(model.instanceType);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InstanceStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Collection<LifecycleEvent.Builder> getLifecycleEvents() {
            return this.lifecycleEvents != null ? (Collection)this.lifecycleEvents.stream().map(LifecycleEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent ... lifecycleEvents) {
            this.lifecycleEvents(Arrays.asList(lifecycleEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... lifecycleEvents) {
            this.lifecycleEvents(Stream.of(lifecycleEvents).map(c -> (LifecycleEvent)((LifecycleEvent.Builder)LifecycleEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent.BuilderImpl> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copyFromBuilder(lifecycleEvents);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public InstanceSummary build() {
            return new InstanceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceSummary> {
        public Builder deploymentId(String var1);

        public Builder instanceId(String var1);

        public Builder status(String var1);

        public Builder status(InstanceStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleEvents(Collection<LifecycleEvent> var1);

        public Builder lifecycleEvents(LifecycleEvent ... var1);

        public Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);
    }
}

