/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.InstanceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentInstanceResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, GetDeploymentInstanceResponse> {
    private static final SdkField<InstanceSummary> INSTANCE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetDeploymentInstanceResponse.getter(GetDeploymentInstanceResponse::instanceSummary)).setter(GetDeploymentInstanceResponse.setter(Builder::instanceSummary)).constructor(InstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SUMMARY_FIELD));
    private final InstanceSummary instanceSummary;

    private GetDeploymentInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceSummary = builder.instanceSummary;
    }

    public InstanceSummary instanceSummary() {
        return this.instanceSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentInstanceResponse)) {
            return false;
        }
        GetDeploymentInstanceResponse other = (GetDeploymentInstanceResponse)((Object)obj);
        return Objects.equals(this.instanceSummary(), other.instanceSummary());
    }

    public String toString() {
        return ToString.builder((String)"GetDeploymentInstanceResponse").add("InstanceSummary", (Object)this.instanceSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceSummary": {
                return Optional.ofNullable(clazz.cast(this.instanceSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentInstanceResponse, T> g) {
        return obj -> g.apply((GetDeploymentInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private InstanceSummary instanceSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentInstanceResponse model) {
            super(model);
            this.instanceSummary(model.instanceSummary);
        }

        public final InstanceSummary.Builder getInstanceSummary() {
            return this.instanceSummary != null ? this.instanceSummary.toBuilder() : null;
        }

        @Override
        public final Builder instanceSummary(InstanceSummary instanceSummary) {
            this.instanceSummary = instanceSummary;
            return this;
        }

        public final void setInstanceSummary(InstanceSummary.BuilderImpl instanceSummary) {
            this.instanceSummary = instanceSummary != null ? instanceSummary.build() : null;
        }

        @Override
        public GetDeploymentInstanceResponse build() {
            return new GetDeploymentInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentInstanceResponse> {
        public Builder instanceSummary(InstanceSummary var1);

        default public Builder instanceSummary(Consumer<InstanceSummary.Builder> instanceSummary) {
            return this.instanceSummary((InstanceSummary)((InstanceSummary.Builder)InstanceSummary.builder().applyMutation(instanceSummary)).build());
        }
    }
}

