/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.RevisionInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RevisionInfoMarshaller {
    private static final MarshallingInfo<StructuredPojo> REVISIONLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionLocation").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GENERICREVISIONINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("genericRevisionInfo").isBinary(false).build();
    private static final RevisionInfoMarshaller INSTANCE = new RevisionInfoMarshaller();

    private RevisionInfoMarshaller() {
    }

    public static RevisionInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RevisionInfo revisionInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)revisionInfo, (String)"revisionInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)revisionInfo.revisionLocation(), REVISIONLOCATION_BINDING);
            protocolMarshaller.marshall((Object)revisionInfo.genericRevisionInfo(), GENERICREVISIONINFO_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

