/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCode {
    DEPLOYMENT_GROUP_MISSING("DEPLOYMENT_GROUP_MISSING"),
    APPLICATION_MISSING("APPLICATION_MISSING"),
    REVISION_MISSING("REVISION_MISSING"),
    IAM_ROLE_MISSING("IAM_ROLE_MISSING"),
    IAM_ROLE_PERMISSIONS("IAM_ROLE_PERMISSIONS"),
    NO_EC2_SUBSCRIPTION("NO_EC2_SUBSCRIPTION"),
    OVER_MAX_INSTANCES("OVER_MAX_INSTANCES"),
    NO_INSTANCES("NO_INSTANCES"),
    TIMEOUT("TIMEOUT"),
    HEALTH_CONSTRAINTS_INVALID("HEALTH_CONSTRAINTS_INVALID"),
    HEALTH_CONSTRAINTS("HEALTH_CONSTRAINTS"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    THROTTLED("THROTTLED"),
    ALARM_ACTIVE("ALARM_ACTIVE"),
    AGENT_ISSUE("AGENT_ISSUE"),
    AUTO_SCALING_IAM_ROLE_PERMISSIONS("AUTO_SCALING_IAM_ROLE_PERMISSIONS"),
    AUTO_SCALING_CONFIGURATION("AUTO_SCALING_CONFIGURATION"),
    MANUAL_STOP("MANUAL_STOP"),
    MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION("MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION"),
    MISSING_ELB_INFORMATION("MISSING_ELB_INFORMATION"),
    MISSING_GITHUB_TOKEN("MISSING_GITHUB_TOKEN"),
    ELASTIC_LOAD_BALANCING_INVALID("ELASTIC_LOAD_BALANCING_INVALID"),
    ELB_INVALID_INSTANCE("ELB_INVALID_INSTANCE"),
    INVALID_LAMBDA_CONFIGURATION("INVALID_LAMBDA_CONFIGURATION"),
    INVALID_LAMBDA_FUNCTION("INVALID_LAMBDA_FUNCTION"),
    HOOK_EXECUTION_FAILURE("HOOK_EXECUTION_FAILURE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        return Stream.of(ErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

