/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentConfigInfoMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTCONFIGID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentConfigId").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTCONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentConfigName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MINIMUMHEALTHYHOSTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("minimumHealthyHosts").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createTime").isBinary(false).build();
    private static final DeploymentConfigInfoMarshaller INSTANCE = new DeploymentConfigInfoMarshaller();

    private DeploymentConfigInfoMarshaller() {
    }

    public static DeploymentConfigInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeploymentConfigInfo deploymentConfigInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deploymentConfigInfo, (String)"deploymentConfigInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deploymentConfigInfo.deploymentConfigId(), DEPLOYMENTCONFIGID_BINDING);
            protocolMarshaller.marshall((Object)deploymentConfigInfo.deploymentConfigName(), DEPLOYMENTCONFIGNAME_BINDING);
            protocolMarshaller.marshall((Object)deploymentConfigInfo.minimumHealthyHosts(), MINIMUMHEALTHYHOSTS_BINDING);
            protocolMarshaller.marshall((Object)deploymentConfigInfo.createTime(), CREATETIME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

