/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentInstancesResponse;

public class ListDeploymentInstancesIterable
implements SdkIterable<ListDeploymentInstancesResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentInstancesIterable(CodeDeployClient client, ListDeploymentInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentInstancesResponseFetcher();
    }

    public Iterator<ListDeploymentInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> instancesList() {
        Function<ListDeploymentInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.instancesList() != null) {
                return response.instancesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListDeploymentInstancesIterable resume(ListDeploymentInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeploymentInstancesIterable(this.client, (ListDeploymentInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeploymentInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDeploymentInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDeploymentInstancesResponseFetcher
    implements SyncPageFetcher<ListDeploymentInstancesResponse> {
        private ListDeploymentInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentInstancesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public ListDeploymentInstancesResponse nextPage(ListDeploymentInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentInstancesIterable.this.client.listDeploymentInstances(ListDeploymentInstancesIterable.this.firstRequest);
            }
            return ListDeploymentInstancesIterable.this.client.listDeploymentInstances((ListDeploymentInstancesRequest)((Object)ListDeploymentInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

