/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, GetApplicationRequest> {
    private final String applicationName;

    private GetApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
    }

    public String applicationName() {
        return this.applicationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRequest)) {
            return false;
        }
        GetApplicationRequest other = (GetApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName());
    }

    public String toString() {
        return ToString.builder((String)"GetApplicationRequest").add("ApplicationName", (Object)this.applicationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationRequest build() {
            return new GetApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, GetApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

