/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RevisionLocationMarshaller {
    private static final MarshallingInfo<String> REVISIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revisionType").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> S3LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Location").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> GITHUBLOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gitHubLocation").isBinary(false).build();
    private static final RevisionLocationMarshaller INSTANCE = new RevisionLocationMarshaller();

    private RevisionLocationMarshaller() {
    }

    public static RevisionLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RevisionLocation revisionLocation, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)revisionLocation, (String)"revisionLocation");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)revisionLocation.revisionTypeAsString(), REVISIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.s3Location(), S3LOCATION_BINDING);
            protocolMarshaller.marshall((Object)revisionLocation.gitHubLocation(), GITHUBLOCATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

