/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.codedeploy.CodeDeployAsyncClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;

public class ListDeploymentConfigsPublisher
implements SdkPublisher<ListDeploymentConfigsResponse> {
    private final CodeDeployAsyncClient client;
    private final ListDeploymentConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDeploymentConfigsPublisher(CodeDeployAsyncClient client, ListDeploymentConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDeploymentConfigsPublisher(CodeDeployAsyncClient client, ListDeploymentConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDeploymentConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDeploymentConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<String> deploymentConfigsList() {
        Function<ListDeploymentConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentConfigsList() != null) {
                return response.deploymentConfigsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListDeploymentConfigsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListDeploymentConfigsPublisher resume(ListDeploymentConfigsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeploymentConfigsPublisher(this.client, (ListDeploymentConfigsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeploymentConfigsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDeploymentConfigsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDeploymentConfigsResponseFetcher
    implements AsyncPageFetcher<ListDeploymentConfigsResponse> {
        private ListDeploymentConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentConfigsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListDeploymentConfigsResponse> nextPage(ListDeploymentConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentConfigsPublisher.this.client.listDeploymentConfigs(ListDeploymentConfigsPublisher.this.firstRequest);
            }
            return ListDeploymentConfigsPublisher.this.client.listDeploymentConfigs((ListDeploymentConfigsRequest)((Object)ListDeploymentConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

