/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.GenericRevisionInfo;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.transform.RevisionInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RevisionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, RevisionInfo> {
    private final RevisionLocation revisionLocation;
    private final GenericRevisionInfo genericRevisionInfo;

    private RevisionInfo(BuilderImpl builder) {
        this.revisionLocation = builder.revisionLocation;
        this.genericRevisionInfo = builder.genericRevisionInfo;
    }

    public RevisionLocation revisionLocation() {
        return this.revisionLocation;
    }

    public GenericRevisionInfo genericRevisionInfo() {
        return this.genericRevisionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.genericRevisionInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevisionInfo)) {
            return false;
        }
        RevisionInfo other = (RevisionInfo)obj;
        return Objects.equals(this.revisionLocation(), other.revisionLocation()) && Objects.equals(this.genericRevisionInfo(), other.genericRevisionInfo());
    }

    public String toString() {
        return ToString.builder((String)"RevisionInfo").add("RevisionLocation", (Object)this.revisionLocation()).add("GenericRevisionInfo", (Object)this.genericRevisionInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "revisionLocation": {
                return Optional.of(clazz.cast(this.revisionLocation()));
            }
            case "genericRevisionInfo": {
                return Optional.of(clazz.cast(this.genericRevisionInfo()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RevisionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private RevisionLocation revisionLocation;
        private GenericRevisionInfo genericRevisionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(RevisionInfo model) {
            this.revisionLocation(model.revisionLocation);
            this.genericRevisionInfo(model.genericRevisionInfo);
        }

        public final RevisionLocation.Builder getRevisionLocation() {
            return this.revisionLocation != null ? this.revisionLocation.toBuilder() : null;
        }

        @Override
        public final Builder revisionLocation(RevisionLocation revisionLocation) {
            this.revisionLocation = revisionLocation;
            return this;
        }

        public final void setRevisionLocation(RevisionLocation.BuilderImpl revisionLocation) {
            this.revisionLocation = revisionLocation != null ? revisionLocation.build() : null;
        }

        public final GenericRevisionInfo.Builder getGenericRevisionInfo() {
            return this.genericRevisionInfo != null ? this.genericRevisionInfo.toBuilder() : null;
        }

        @Override
        public final Builder genericRevisionInfo(GenericRevisionInfo genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo;
            return this;
        }

        public final void setGenericRevisionInfo(GenericRevisionInfo.BuilderImpl genericRevisionInfo) {
            this.genericRevisionInfo = genericRevisionInfo != null ? genericRevisionInfo.build() : null;
        }

        public RevisionInfo build() {
            return new RevisionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RevisionInfo> {
        public Builder revisionLocation(RevisionLocation var1);

        default public Builder revisionLocation(Consumer<RevisionLocation.Builder> revisionLocation) {
            return this.revisionLocation((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().apply(revisionLocation)).build());
        }

        public Builder genericRevisionInfo(GenericRevisionInfo var1);

        default public Builder genericRevisionInfo(Consumer<GenericRevisionInfo.Builder> genericRevisionInfo) {
            return this.genericRevisionInfo((GenericRevisionInfo)((GenericRevisionInfo.Builder)GenericRevisionInfo.builder().apply(genericRevisionInfo)).build());
        }
    }
}

