/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetApplicationRevisionRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, GetApplicationRevisionRequest> {
    private final String applicationName;
    private final RevisionLocation revision;

    private GetApplicationRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.revision = builder.revision;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public RevisionLocation revision() {
        return this.revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationRevisionRequest)) {
            return false;
        }
        GetApplicationRevisionRequest other = (GetApplicationRevisionRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.revision(), other.revision());
    }

    public String toString() {
        return ToString.builder((String)"GetApplicationRevisionRequest").add("ApplicationName", (Object)this.applicationName()).add("Revision", (Object)this.revision()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "revision": {
                return Optional.of(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private RevisionLocation revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationRevisionRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.revision(model.revision);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetApplicationRevisionRequest build() {
            return new GetApplicationRevisionRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, GetApplicationRevisionRequest> {
        public Builder applicationName(String var1);

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().apply(revision)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

