/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfo;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetOnPremisesInstancesResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
    private final List<InstanceInfo> instanceInfos;

    private BatchGetOnPremisesInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInfos = builder.instanceInfos;
    }

    public List<InstanceInfo> instanceInfos() {
        return this.instanceInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInfos());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesResponse)) {
            return false;
        }
        BatchGetOnPremisesInstancesResponse other = (BatchGetOnPremisesInstancesResponse)((Object)obj);
        return Objects.equals(this.instanceInfos(), other.instanceInfos());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetOnPremisesInstancesResponse").add("InstanceInfos", this.instanceInfos()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceInfos": {
                return Optional.of(clazz.cast(this.instanceInfos()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<InstanceInfo> instanceInfos;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesResponse model) {
            super(model);
            this.instanceInfos(model.instanceInfos);
        }

        public final Collection<InstanceInfo.Builder> getInstanceInfos() {
            return this.instanceInfos != null ? (Collection)this.instanceInfos.stream().map(InstanceInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(InstanceInfo ... instanceInfos) {
            this.instanceInfos(Arrays.asList(instanceInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(Consumer<InstanceInfo.Builder> ... instanceInfos) {
            this.instanceInfos(Stream.of(instanceInfos).map(c -> (InstanceInfo)((InstanceInfo.Builder)InstanceInfo.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceInfos(Collection<InstanceInfo.BuilderImpl> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copyFromBuilder(instanceInfos);
        }

        @Override
        public BatchGetOnPremisesInstancesResponse build() {
            return new BatchGetOnPremisesInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    CopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
        public Builder instanceInfos(Collection<InstanceInfo> var1);

        public Builder instanceInfos(InstanceInfo ... var1);

        public Builder instanceInfos(Consumer<InstanceInfo.Builder> ... var1);
    }
}

