/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, BatchGetDeploymentsRequest> {
    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentIds = builder.deploymentIds;
    }

    public List<String> deploymentIds() {
        return this.deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest)((Object)obj);
        return Objects.equals(this.deploymentIds(), other.deploymentIds());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetDeploymentsRequest").add("DeploymentIds", this.deploymentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentIds": {
                return Optional.of(clazz.cast(this.deploymentIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private List<String> deploymentIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            super(model);
            this.deploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            return this.deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String ... deploymentIds) {
            this.deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        public Builder deploymentIds(Collection<String> var1);

        public Builder deploymentIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

