/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.model.InstanceNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOnPremisesInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListOnPremisesInstancesResponse> {
    private final List<String> instanceNames;
    private final String nextToken;

    private ListOnPremisesInstancesResponse(BuilderImpl builder) {
        this.instanceNames = builder.instanceNames;
        this.nextToken = builder.nextToken;
    }

    public List<String> instanceNames() {
        return this.instanceNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceNames() == null ? 0 : this.instanceNames().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOnPremisesInstancesResponse)) {
            return false;
        }
        ListOnPremisesInstancesResponse other = (ListOnPremisesInstancesResponse)((Object)obj);
        if (other.instanceNames() == null ^ this.instanceNames() == null) {
            return false;
        }
        if (other.instanceNames() != null && !other.instanceNames().equals(this.instanceNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceNames() != null) {
            sb.append("InstanceNames: ").append(this.instanceNames()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceNames = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOnPremisesInstancesResponse model) {
            this.setInstanceNames(model.instanceNames);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getInstanceNames() {
            return this.instanceNames;
        }

        @Override
        public final Builder instanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceNames(String ... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
            return this;
        }

        public final void setInstanceNames(Collection<String> instanceNames) {
            this.instanceNames = InstanceNameListCopier.copy(instanceNames);
        }

        @SafeVarargs
        public final void setInstanceNames(String ... instanceNames) {
            if (this.instanceNames == null) {
                this.instanceNames = new SdkInternalList(instanceNames.length);
            }
            for (String e : instanceNames) {
                this.instanceNames.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListOnPremisesInstancesResponse build() {
            return new ListOnPremisesInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListOnPremisesInstancesResponse> {
        public Builder instanceNames(Collection<String> var1);

        public Builder instanceNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

