/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.model.GitHubAccountTokenNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListGitHubAccountTokenNamesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListGitHubAccountTokenNamesResponse> {
    private final List<String> tokenNameList;
    private final String nextToken;

    private ListGitHubAccountTokenNamesResponse(BuilderImpl builder) {
        this.tokenNameList = builder.tokenNameList;
        this.nextToken = builder.nextToken;
    }

    public List<String> tokenNameList() {
        return this.tokenNameList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tokenNameList() == null ? 0 : this.tokenNameList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGitHubAccountTokenNamesResponse)) {
            return false;
        }
        ListGitHubAccountTokenNamesResponse other = (ListGitHubAccountTokenNamesResponse)((Object)obj);
        if (other.tokenNameList() == null ^ this.tokenNameList() == null) {
            return false;
        }
        if (other.tokenNameList() != null && !other.tokenNameList().equals(this.tokenNameList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tokenNameList() != null) {
            sb.append("TokenNameList: ").append(this.tokenNameList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> tokenNameList = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGitHubAccountTokenNamesResponse model) {
            this.setTokenNameList(model.tokenNameList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getTokenNameList() {
            return this.tokenNameList;
        }

        @Override
        public final Builder tokenNameList(Collection<String> tokenNameList) {
            this.tokenNameList = GitHubAccountTokenNameListCopier.copy(tokenNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tokenNameList(String ... tokenNameList) {
            if (this.tokenNameList == null) {
                this.tokenNameList = new SdkInternalList(tokenNameList.length);
            }
            for (String e : tokenNameList) {
                this.tokenNameList.add(e);
            }
            return this;
        }

        public final void setTokenNameList(Collection<String> tokenNameList) {
            this.tokenNameList = GitHubAccountTokenNameListCopier.copy(tokenNameList);
        }

        @SafeVarargs
        public final void setTokenNameList(String ... tokenNameList) {
            if (this.tokenNameList == null) {
                this.tokenNameList = new SdkInternalList(tokenNameList.length);
            }
            for (String e : tokenNameList) {
                this.tokenNameList.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListGitHubAccountTokenNamesResponse build() {
            return new ListGitHubAccountTokenNamesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListGitHubAccountTokenNamesResponse> {
        public Builder tokenNameList(Collection<String> var1);

        public Builder tokenNameList(String ... var1);

        public Builder nextToken(String var1);
    }
}

