/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.model.Diagnostics;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus;
import software.amazon.awssdk.services.codedeploy.transform.LifecycleEventMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, LifecycleEvent> {
    private final String lifecycleEventName;
    private final Diagnostics diagnostics;
    private final Date startTime;
    private final Date endTime;
    private final String status;

    private LifecycleEvent(BuilderImpl builder) {
        this.lifecycleEventName = builder.lifecycleEventName;
        this.diagnostics = builder.diagnostics;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
    }

    public String lifecycleEventName() {
        return this.lifecycleEventName;
    }

    public Diagnostics diagnostics() {
        return this.diagnostics;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lifecycleEventName() == null ? 0 : this.lifecycleEventName().hashCode());
        hashCode = 31 * hashCode + (this.diagnostics() == null ? 0 : this.diagnostics().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleEvent)) {
            return false;
        }
        LifecycleEvent other = (LifecycleEvent)obj;
        if (other.lifecycleEventName() == null ^ this.lifecycleEventName() == null) {
            return false;
        }
        if (other.lifecycleEventName() != null && !other.lifecycleEventName().equals(this.lifecycleEventName())) {
            return false;
        }
        if (other.diagnostics() == null ^ this.diagnostics() == null) {
            return false;
        }
        if (other.diagnostics() != null && !other.diagnostics().equals(this.diagnostics())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lifecycleEventName() != null) {
            sb.append("LifecycleEventName: ").append(this.lifecycleEventName()).append(",");
        }
        if (this.diagnostics() != null) {
            sb.append("Diagnostics: ").append(this.diagnostics()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LifecycleEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String lifecycleEventName;
        private Diagnostics diagnostics;
        private Date startTime;
        private Date endTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleEvent model) {
            this.setLifecycleEventName(model.lifecycleEventName);
            this.setDiagnostics(model.diagnostics);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setStatus(model.status);
        }

        public final String getLifecycleEventName() {
            return this.lifecycleEventName;
        }

        @Override
        public final Builder lifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
            return this;
        }

        public final void setLifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
        }

        public final Diagnostics getDiagnostics() {
            return this.diagnostics;
        }

        @Override
        public final Builder diagnostics(Diagnostics diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public final void setDiagnostics(Diagnostics diagnostics) {
            this.diagnostics = diagnostics;
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecycleEventStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(LifecycleEventStatus status) {
            this.status(status.toString());
        }

        public LifecycleEvent build() {
            return new LifecycleEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleEvent> {
        public Builder lifecycleEventName(String var1);

        public Builder diagnostics(Diagnostics var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);

        public Builder status(String var1);

        public Builder status(LifecycleEventStatus var1);
    }
}

