/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.GitHubLocationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GitHubLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, GitHubLocation> {
    private final String repository;
    private final String commitId;

    private GitHubLocation(BuilderImpl builder) {
        this.repository = builder.repository;
        this.commitId = builder.commitId;
    }

    public String repository() {
        return this.repository;
    }

    public String commitId() {
        return this.commitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.repository() == null ? 0 : this.repository().hashCode());
        hashCode = 31 * hashCode + (this.commitId() == null ? 0 : this.commitId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubLocation)) {
            return false;
        }
        GitHubLocation other = (GitHubLocation)obj;
        if (other.repository() == null ^ this.repository() == null) {
            return false;
        }
        if (other.repository() != null && !other.repository().equals(this.repository())) {
            return false;
        }
        if (other.commitId() == null ^ this.commitId() == null) {
            return false;
        }
        return other.commitId() == null || other.commitId().equals(this.commitId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.repository() != null) {
            sb.append("Repository: ").append(this.repository()).append(",");
        }
        if (this.commitId() != null) {
            sb.append("CommitId: ").append(this.commitId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitHubLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String repository;
        private String commitId;

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubLocation model) {
            this.setRepository(model.repository);
            this.setCommitId(model.commitId);
        }

        public final String getRepository() {
            return this.repository;
        }

        @Override
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public GitHubLocation build() {
            return new GitHubLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GitHubLocation> {
        public Builder repository(String var1);

        public Builder commitId(String var1);
    }
}

