/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.services.codedeploy.transform.GenericRevisionInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GenericRevisionInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, GenericRevisionInfo> {
    private final String description;
    private final List<String> deploymentGroups;
    private final Date firstUsedTime;
    private final Date lastUsedTime;
    private final Date registerTime;

    private GenericRevisionInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.deploymentGroups = builder.deploymentGroups;
        this.firstUsedTime = builder.firstUsedTime;
        this.lastUsedTime = builder.lastUsedTime;
        this.registerTime = builder.registerTime;
    }

    public String description() {
        return this.description;
    }

    public List<String> deploymentGroups() {
        return this.deploymentGroups;
    }

    public Date firstUsedTime() {
        return this.firstUsedTime;
    }

    public Date lastUsedTime() {
        return this.lastUsedTime;
    }

    public Date registerTime() {
        return this.registerTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.deploymentGroups() == null ? 0 : this.deploymentGroups().hashCode());
        hashCode = 31 * hashCode + (this.firstUsedTime() == null ? 0 : this.firstUsedTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUsedTime() == null ? 0 : this.lastUsedTime().hashCode());
        hashCode = 31 * hashCode + (this.registerTime() == null ? 0 : this.registerTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericRevisionInfo)) {
            return false;
        }
        GenericRevisionInfo other = (GenericRevisionInfo)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.deploymentGroups() == null ^ this.deploymentGroups() == null) {
            return false;
        }
        if (other.deploymentGroups() != null && !other.deploymentGroups().equals(this.deploymentGroups())) {
            return false;
        }
        if (other.firstUsedTime() == null ^ this.firstUsedTime() == null) {
            return false;
        }
        if (other.firstUsedTime() != null && !other.firstUsedTime().equals(this.firstUsedTime())) {
            return false;
        }
        if (other.lastUsedTime() == null ^ this.lastUsedTime() == null) {
            return false;
        }
        if (other.lastUsedTime() != null && !other.lastUsedTime().equals(this.lastUsedTime())) {
            return false;
        }
        if (other.registerTime() == null ^ this.registerTime() == null) {
            return false;
        }
        return other.registerTime() == null || other.registerTime().equals(this.registerTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.deploymentGroups() != null) {
            sb.append("DeploymentGroups: ").append(this.deploymentGroups()).append(",");
        }
        if (this.firstUsedTime() != null) {
            sb.append("FirstUsedTime: ").append(this.firstUsedTime()).append(",");
        }
        if (this.lastUsedTime() != null) {
            sb.append("LastUsedTime: ").append(this.lastUsedTime()).append(",");
        }
        if (this.registerTime() != null) {
            sb.append("RegisterTime: ").append(this.registerTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GenericRevisionInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> deploymentGroups = new SdkInternalList();
        private Date firstUsedTime;
        private Date lastUsedTime;
        private Date registerTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenericRevisionInfo model) {
            this.setDescription(model.description);
            this.setDeploymentGroups(model.deploymentGroups);
            this.setFirstUsedTime(model.firstUsedTime);
            this.setLastUsedTime(model.lastUsedTime);
            this.setRegisterTime(model.registerTime);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getDeploymentGroups() {
            return this.deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String ... deploymentGroups) {
            if (this.deploymentGroups == null) {
                this.deploymentGroups = new SdkInternalList(deploymentGroups.length);
            }
            for (String e : deploymentGroups) {
                this.deploymentGroups.add(e);
            }
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        @SafeVarargs
        public final void setDeploymentGroups(String ... deploymentGroups) {
            if (this.deploymentGroups == null) {
                this.deploymentGroups = new SdkInternalList(deploymentGroups.length);
            }
            for (String e : deploymentGroups) {
                this.deploymentGroups.add(e);
            }
        }

        public final Date getFirstUsedTime() {
            return this.firstUsedTime;
        }

        @Override
        public final Builder firstUsedTime(Date firstUsedTime) {
            this.firstUsedTime = StandardMemberCopier.copy((Date)firstUsedTime);
            return this;
        }

        public final void setFirstUsedTime(Date firstUsedTime) {
            this.firstUsedTime = StandardMemberCopier.copy((Date)firstUsedTime);
        }

        public final Date getLastUsedTime() {
            return this.lastUsedTime;
        }

        @Override
        public final Builder lastUsedTime(Date lastUsedTime) {
            this.lastUsedTime = StandardMemberCopier.copy((Date)lastUsedTime);
            return this;
        }

        public final void setLastUsedTime(Date lastUsedTime) {
            this.lastUsedTime = StandardMemberCopier.copy((Date)lastUsedTime);
        }

        public final Date getRegisterTime() {
            return this.registerTime;
        }

        @Override
        public final Builder registerTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy((Date)registerTime);
            return this;
        }

        public final void setRegisterTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy((Date)registerTime);
        }

        public GenericRevisionInfo build() {
            return new GenericRevisionInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GenericRevisionInfo> {
        public Builder description(String var1);

        public Builder deploymentGroups(Collection<String> var1);

        public Builder deploymentGroups(String ... var1);

        public Builder firstUsedTime(Date var1);

        public Builder lastUsedTime(Date var1);

        public Builder registerTime(Date var1);
    }
}

