/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupInfoListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
    private final List<DeploymentGroupInfo> deploymentGroupsInfo;
    private final String errorMessage;

    private BatchGetDeploymentGroupsResponse(BuilderImpl builder) {
        this.deploymentGroupsInfo = builder.deploymentGroupsInfo;
        this.errorMessage = builder.errorMessage;
    }

    public List<DeploymentGroupInfo> deploymentGroupsInfo() {
        return this.deploymentGroupsInfo;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentGroupsInfo() == null ? 0 : this.deploymentGroupsInfo().hashCode());
        hashCode = 31 * hashCode + (this.errorMessage() == null ? 0 : this.errorMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentGroupsResponse)) {
            return false;
        }
        BatchGetDeploymentGroupsResponse other = (BatchGetDeploymentGroupsResponse)((Object)obj);
        if (other.deploymentGroupsInfo() == null ^ this.deploymentGroupsInfo() == null) {
            return false;
        }
        if (other.deploymentGroupsInfo() != null && !other.deploymentGroupsInfo().equals(this.deploymentGroupsInfo())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        return other.errorMessage() == null || other.errorMessage().equals(this.errorMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentGroupsInfo() != null) {
            sb.append("DeploymentGroupsInfo: ").append(this.deploymentGroupsInfo()).append(",");
        }
        if (this.errorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.errorMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DeploymentGroupInfo> deploymentGroupsInfo = new SdkInternalList();
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentGroupsResponse model) {
            this.setDeploymentGroupsInfo(model.deploymentGroupsInfo);
            this.setErrorMessage(model.errorMessage);
        }

        public final Collection<DeploymentGroupInfo> getDeploymentGroupsInfo() {
            return this.deploymentGroupsInfo;
        }

        @Override
        public final Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroupsInfo(DeploymentGroupInfo ... deploymentGroupsInfo) {
            if (this.deploymentGroupsInfo == null) {
                this.deploymentGroupsInfo = new SdkInternalList(deploymentGroupsInfo.length);
            }
            for (DeploymentGroupInfo e : deploymentGroupsInfo) {
                this.deploymentGroupsInfo.add(e);
            }
            return this;
        }

        public final void setDeploymentGroupsInfo(Collection<DeploymentGroupInfo> deploymentGroupsInfo) {
            this.deploymentGroupsInfo = DeploymentGroupInfoListCopier.copy(deploymentGroupsInfo);
        }

        @SafeVarargs
        public final void setDeploymentGroupsInfo(DeploymentGroupInfo ... deploymentGroupsInfo) {
            if (this.deploymentGroupsInfo == null) {
                this.deploymentGroupsInfo = new SdkInternalList(deploymentGroupsInfo.length);
            }
            for (DeploymentGroupInfo e : deploymentGroupsInfo) {
                this.deploymentGroupsInfo.add(e);
            }
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public BatchGetDeploymentGroupsResponse build() {
            return new BatchGetDeploymentGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetDeploymentGroupsResponse> {
        public Builder deploymentGroupsInfo(Collection<DeploymentGroupInfo> var1);

        public Builder deploymentGroupsInfo(DeploymentGroupInfo ... var1);

        public Builder errorMessage(String var1);
    }
}

